/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.nodetype;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDefStore;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRXNodeTypeRegistry
extends NodeTypeRegistry {
    private static Logger log = LoggerFactory.getLogger(CRXNodeTypeRegistry.class);
    private static final String CRX_NODETYPES_RESOURCE_NAME_CND = "crx_nodetypes.cnd";

    public static NodeTypeRegistry create(NamespaceRegistry nsReg, FileSystem ntStore) throws RepositoryException {
        return new CRXNodeTypeRegistry(nsReg, ntStore);
    }

    protected CRXNodeTypeRegistry(NamespaceRegistry nsReg, FileSystem ntStore) throws RepositoryException {
        super(nsReg, ntStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBuiltInNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        super.loadBuiltInNodeTypeDefs(store);
        try {
            InputStream cnd = CRXNodeTypeRegistry.class.getResourceAsStream(CRX_NODETYPES_RESOURCE_NAME_CND);
            try {
                store.loadCND((Reader)new InputStreamReader(cnd, "UTF-8"), CRX_NODETYPES_RESOURCE_NAME_CND);
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                cnd.close();
                throw throwable;
            }
            cnd.close();
            {
            }
        }
        catch (IOException e) {
            String error = "internal error: failed to read built-in node type definitions stored in crx_nodetypes.cnd";
            log.debug(error, (Throwable)e);
            throw new RepositoryException(error, (Throwable)e);
        }
        catch (InvalidNodeTypeDefException e) {
            String error = "internal error: failed to read built-in node type definitions stored in crx_nodetypes.cnd";
            log.debug(error, (Throwable)e);
            throw new RepositoryException(error, (Throwable)e);
        }
    }

    protected void loadCustomNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        super.loadCustomNodeTypeDefs(store);
        ArrayList<Name> conflicting = new ArrayList<Name>();
        for (QNodeTypeDefinition ntDef : store.all()) {
            if (!this.isBuiltIn(ntDef.getName())) continue;
            conflicting.add(ntDef.getName());
        }
        for (Name ntName : conflicting) {
            log.warn("Conflicting custom node type {} ignored. Already defined as built in node type.", (Object)ntName);
            store.remove(ntName);
        }
    }

    protected void checkForReferencesInContent(Name nodeTypeName) {
    }
}

