/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.lock;

import java.util.concurrent.ScheduledExecutorService;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.lock.LockInfo;
import org.apache.jackrabbit.core.lock.LockManagerImpl;

public class CRXLockManagerImpl
extends LockManagerImpl {
    private final boolean simpleLocking;

    public CRXLockManagerImpl(SessionImpl session, FileSystem fs, boolean simpleLocking, ScheduledExecutorService executor) throws RepositoryException {
        super(session, fs, executor);
        this.simpleLocking = simpleLocking;
    }

    protected void checkLock(LockInfo info, Session session) throws LockException, RepositoryException {
        String userID;
        String owner;
        if (this.simpleLocking && (owner = info.getLockOwner()).equals(userID = session.getUserID())) {
            return;
        }
        super.checkLock(info, session);
    }

    protected void checkUnlock(LockInfo info, Session session) throws LockException, RepositoryException {
        String userID;
        String owner;
        if (this.simpleLocking && ((owner = info.getLockOwner()).equals(userID = session.getUserID()) || this.isAdminUser(session))) {
            return;
        }
        super.checkUnlock(info, session);
    }

    private boolean isAdminUser(Session session) {
        if (session instanceof SessionImpl) {
            return ((SessionImpl)session).isAdmin();
        }
        return "admin".equals(session.getUserID());
    }
}

