/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.journal;

import com.day.crx.cluster.ObjectStub;
import com.day.crx.cluster.Request;
import com.day.crx.core.journal.JournalOperations;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.core.journal.JournalException;

public class JournalOperationsStub
extends ObjectStub
implements JournalOperations {
    public long getRevision() throws JournalException {
        Request request = this.createRequest("getRevision");
        try {
            return request.getResponse().readLong();
        }
        catch (IOException e) {
            throw JournalOperationsStub.toJournalException(request.getDisplayName(), e);
        }
    }

    public void lock() throws JournalException {
        Request request = this.createRequest("lock");
        try {
            request.invoke();
        }
        catch (IOException e) {
            throw JournalOperationsStub.toJournalException(request.getDisplayName(), e);
        }
    }

    public long append(String producerId, InputStream ins, int length) throws JournalException {
        Request request = this.createRequest("append");
        try {
            int len;
            request.writeUTF(producerId);
            byte[] buffer = new byte[8192];
            request.writeInt(length);
            while ((len = ins.read(buffer)) > 0) {
                request.write(buffer, 0, len);
            }
            return request.getResponse().readLong();
        }
        catch (IOException e) {
            throw JournalOperationsStub.toJournalException(request.getDisplayName(), e);
        }
    }

    public void unlock() {
        Request request = this.createRequest("unlock");
        try {
            request.invoke();
        }
        catch (IOException e) {
            this.log(request.getDisplayName(), e);
        }
    }

    private static JournalException toJournalException(String methodName, IOException e) {
        Throwable t = e.getCause();
        if (t == null) {
            t = e;
        }
        if (t instanceof JournalException) {
            return (JournalException)t;
        }
        String msg = "Unable to invoke: " + methodName;
        return new JournalException(msg, t);
    }
}

