/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.journal;

import com.day.crx.cluster.InvokeHandler;
import com.day.crx.cluster.ResponseHandler;
import com.day.crx.cluster.TypeId;
import com.day.crx.core.journal.JournalOperations;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import org.apache.jackrabbit.core.journal.JournalException;

abstract class JournalImplBase
extends InvokeHandler
implements JournalOperations {
    private static final HashMap<String, Integer> OPERATIONS = new HashMap();

    protected JournalImplBase(String instanceId) {
        super(instanceId);
    }

    protected void doInvoke(String operation, DataInput in, ResponseHandler handler) throws IOException {
        switch (OPERATIONS.get(operation)) {
            case 0: {
                try {
                    handler.createReply().writeLong(this.getRevision());
                }
                catch (JournalException e) {
                    handler.createExceptionReply(e);
                }
                break;
            }
            case 1: {
                try {
                    this.lock();
                }
                catch (JournalException e) {
                    handler.createExceptionReply(e);
                }
                break;
            }
            case 2: {
                String producerId = in.readUTF();
                int length = in.readInt();
                byte[] buffer = new byte[length];
                in.readFully(buffer);
                try {
                    long revision = this.append(producerId, new ByteArrayInputStream(buffer), length);
                    handler.createReply().writeLong(revision);
                }
                catch (JournalException e) {
                    handler.createExceptionReply(e);
                }
                break;
            }
            case 3: {
                this.unlock();
            }
        }
    }

    protected TypeId getTypeId() {
        return JournalImplBase.toTypeId(JournalOperations.class);
    }

    static {
        OPERATIONS.put("getRevision", new Integer(0));
        OPERATIONS.put("lock", new Integer(1));
        OPERATIONS.put("append", new Integer(2));
        OPERATIONS.put("unlock", new Integer(3));
    }
}

