/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.journal;

import com.day.crx.core.journal.RotatingLogFile;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.core.journal.FileRecordLog;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.ReadRecord;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRecordIterator
implements RecordIterator {
    private static Logger log = LoggerFactory.getLogger(FileRecordIterator.class);
    private File directory;
    private String basename;
    private File[] logFiles;
    private long revision;
    private long stopRevision;
    private NamespaceResolver resolver;
    private NamePathResolver npResolver;
    private FileRecordLog recordLog;
    private ReadRecord record;

    public FileRecordIterator(File directory, String basename, long startRevision, long stopRevision, NamespaceResolver resolver, NamePathResolver npResolver) {
        this.directory = directory;
        this.basename = basename;
        this.revision = startRevision;
        this.stopRevision = stopRevision;
        this.resolver = resolver;
        this.npResolver = npResolver;
    }

    public boolean hasNext() {
        return this.revision < this.stopRevision;
    }

    public Record nextRecord() throws NoSuchElementException, JournalException {
        if (!this.hasNext()) {
            String msg = "No next revision.";
            throw new NoSuchElementException(msg);
        }
        try {
            if (this.record != null) {
                this.record.close();
                this.record = null;
            }
        }
        catch (IOException e) {
            this.close();
            String msg = "Unable to skip over record.";
            throw new JournalException(msg, (Throwable)e);
        }
        if (this.recordLog != null && !this.recordLog.contains(this.revision)) {
            this.recordLog.close();
            this.recordLog = null;
        }
        try {
            if (this.recordLog == null) {
                this.recordLog = this.getRecordLog(this.revision);
            }
        }
        catch (IOException e) {
            String msg = "Unable to open record log with revision: " + this.revision;
            throw new JournalException(msg, (Throwable)e);
        }
        try {
            this.record = this.recordLog.read(this.resolver, this.npResolver);
            this.revision = this.record.getRevision();
            return this.record;
        }
        catch (IOException e) {
            String msg = "Unable to read record with revision: " + this.revision;
            throw new JournalException(msg, (Throwable)e);
        }
    }

    public void close() {
        if (this.recordLog != null) {
            this.recordLog.close();
        }
    }

    private FileRecordLog getRecordLog(long revision) throws IOException {
        boolean refresh = false;
        while (true) {
            File[] logFiles = this.getLogFiles(refresh);
            FileRecordLog[] logs = new FileRecordLog[logFiles.length];
            for (int i = 0; i < logFiles.length; ++i) {
                logs[i] = new FileRecordLog(logFiles[i]);
                if (!logs[i].contains(revision)) continue;
                logs[i].seek(revision);
                return logs[i];
            }
            if (refresh) break;
            refresh = true;
        }
        String msg = "No log file found containing revision: " + revision;
        throw new IOException(msg);
    }

    private File[] getLogFiles(boolean refresh) {
        if (!refresh && this.logFiles != null) {
            return this.logFiles;
        }
        if (log.isDebugEnabled()) {
            log.debug("Refreshing list of log files.");
        }
        RotatingLogFile[] rlf = RotatingLogFile.listFiles(this.directory, this.basename);
        this.logFiles = new File[rlf.length];
        for (int i = 0; i < this.logFiles.length; ++i) {
            this.logFiles[i] = rlf[i].getFile();
        }
        return this.logFiles;
    }
}

