/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.journal;

import com.day.crx.cluster.ClusterController;
import com.day.crx.cluster.ClusterRole;
import com.day.crx.cluster.InvokeHandler;
import com.day.crx.core.journal.DefaultLogRotator;
import com.day.crx.core.journal.Duration;
import com.day.crx.core.journal.FileRecordIterator;
import com.day.crx.core.journal.JournalImpl;
import com.day.crx.core.journal.JournalOperations;
import com.day.crx.core.journal.RotatingLogFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.AppendRecord;
import org.apache.jackrabbit.core.journal.FileRecordLog;
import org.apache.jackrabbit.core.journal.FileRevision;
import org.apache.jackrabbit.core.journal.InstanceRevision;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileJournal
extends AbstractJournal
implements ClusterRole {
    public static final String PN_SHARED_PATH = "sharedPath";
    private static final String DEFAULT_BASENAME = "journal";
    private static final int DEFAULT_MAXSIZE = 0x6400000;
    private static final Duration DEFAULT_MAX_AGE = new Duration("P1M");
    private static final String DEFAULT_INSTANCE_ID = "file_journal";
    private static final int DEFAULT_OPERATION_TIMEOUT = 600000;
    private static final String SHARED_PATH_SUB = "journal";
    private static Logger log = LoggerFactory.getLogger(FileJournal.class);
    private String directory;
    private String basename;
    private int maximumSize;
    private Duration maximumAge;
    private int maximumFiles;
    private File rootDirectory;
    private ClusterController clusterController;
    private String instanceId;
    private InvokeHandler handler;
    private String portList;
    private String bindAddress;
    private int connectTimeout;
    private int socketTimeout;
    private boolean preferredMaster;
    private String sharedPath;
    private int operationTimeout = 600000;

    public void init(String id, NamespaceResolver resolver) throws JournalException {
        super.init(id, resolver);
        if (this.directory == null) {
            if (this.sharedPath != null) {
                this.directory = this.sharedPath + File.separatorChar + "journal";
            } else {
                String msg = "Directory not specified.";
                throw new JournalException(msg);
            }
        }
        if (this.basename == null) {
            this.basename = "journal";
        }
        if (this.maximumSize == 0) {
            this.maximumSize = 0x6400000;
        }
        if (this.maximumAge == null) {
            this.maximumAge = DEFAULT_MAX_AGE;
        }
        this.rootDirectory = new File(this.directory);
        this.rootDirectory.mkdirs();
        if (!this.rootDirectory.exists() || !this.rootDirectory.isDirectory()) {
            String msg = "Directory specified does either not exist or is not a directory: " + this.directory;
            throw new JournalException(msg);
        }
        if (this.instanceId == null) {
            this.instanceId = DEFAULT_INSTANCE_ID;
        }
        DefaultLogRotator rotator = new DefaultLogRotator(this.rootDirectory, this.basename);
        rotator.setMaximumAge(this.maximumAge);
        rotator.setMaximumFiles(this.maximumFiles);
        try {
            if (this.clusterController == null) {
                this.clusterController = this.createClusterController(id);
            }
            this.handler = new JournalImpl(this, this.rootDirectory, this.instanceId, this.operationTimeout, rotator);
            this.clusterController.connect(this.handler);
            if (this.preferredMaster) {
                this.clusterController.becomeMaster();
            }
        }
        catch (IOException e) {
            String msg = "Unable to initialize cluster controller.";
            throw new JournalException(msg, (Throwable)e);
        }
    }

    protected ClusterController createClusterController(String identity) throws IOException {
        Properties props = new Properties();
        props.setProperty("com.day.crx.cluster.ClusterController.Identity", identity);
        props.setProperty("com.day.crx.cluster.ClusterController.Path", this.rootDirectory.getPath());
        if (this.portList != null) {
            props.setProperty("com.day.crx.cluster.ClusterController.PortList", this.portList);
        }
        if (this.bindAddress != null) {
            props.setProperty("com.day.crx.cluster.ClusterController.BindAddress", this.bindAddress);
        }
        if (this.connectTimeout != 0) {
            props.setProperty("com.day.crx.cluster.ClusterController.ConnectTimeout", String.valueOf(this.connectTimeout));
        }
        if (this.socketTimeout != 0) {
            props.setProperty("com.day.crx.cluster.ClusterController.SocketTimeout", String.valueOf(this.socketTimeout));
        }
        ClusterController clusterController = ClusterController.init(props);
        if (this.sharedPath != null) {
            clusterController.setProperty(PN_SHARED_PATH, FileJournal.resolvePath(this.sharedPath));
        }
        return clusterController;
    }

    public void setClusterController(ClusterController clusterController) {
        this.clusterController = clusterController;
    }

    public ClusterController getClusterController() {
        return this.clusterController;
    }

    protected void doLock() throws JournalException {
        this.getJournal().lock();
    }

    protected void append(AppendRecord record, InputStream in, int length) throws JournalException {
        long revision = this.getJournal().append(record.getProducerId(), in, length);
        record.setRevision(revision);
    }

    protected void doUnlock(boolean successful) {
        try {
            this.getJournal().unlock();
        }
        catch (JournalException e) {
            String msg = "Error while unlocking.";
            log.warn(msg, (Throwable)e);
        }
    }

    public RecordIterator getRecords() throws JournalException {
        long stopRevision = this.getJournal().getRevision();
        long startRevision = 0L;
        RotatingLogFile[] logFiles = RotatingLogFile.listFiles(this.rootDirectory, this.basename);
        File[] files = new File[logFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = logFiles[i].getFile();
            if (i != 0) continue;
            try {
                FileRecordLog log = new FileRecordLog(files[i]);
                startRevision = log.getPreviousRevision();
                continue;
            }
            catch (IOException e) {
                String msg = "Unable to read startRevision from first record log file";
                throw new JournalException(msg, (Throwable)e);
            }
        }
        return new org.apache.jackrabbit.core.journal.FileRecordIterator(files, startRevision, stopRevision, this.getResolver(), this.getNamePathResolver());
    }

    public RecordIterator getRecords(long startRevision) throws JournalException {
        long stopRevision = this.getJournal().getRevision();
        return new FileRecordIterator(this.rootDirectory, this.basename, startRevision, stopRevision, this.getResolver(), this.getNamePathResolver());
    }

    public void close() {
        if (this.clusterController != null && this.handler != null) {
            this.clusterController.disconnect(this.handler);
        }
    }

    public InstanceRevision getInstanceRevision() throws JournalException {
        return new FileRevision(new File(this.getRevision()), false);
    }

    private JournalOperations getJournal() throws JournalException {
        try {
            return (JournalOperations)this.clusterController.lookup(this.handler.getObjectId());
        }
        catch (IOException e) {
            String msg = "Unable to lookup journal implementation: " + e.getMessage();
            throw new JournalException(msg, (Throwable)e);
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getBasename() {
        return this.basename;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public Duration getMaximumAge() {
        return this.maximumAge;
    }

    public int getMaximumFiles() {
        return this.maximumFiles;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getPortList() {
        return this.portList;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public boolean isPreferredMaster() {
        return this.preferredMaster;
    }

    public String getSharedPath() {
        return this.sharedPath;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public void setMaximumAge(String maximumAge) {
        this.maximumAge = new Duration(maximumAge);
    }

    public void setMaximumFiles(int maximumFiles) {
        this.maximumFiles = maximumFiles;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setPortList(String portList) {
        this.portList = portList;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public void setPreferredMaster(boolean preferredMaster) {
        this.preferredMaster = preferredMaster;
    }

    public void setSharedPath(String sharedPath) {
        this.sharedPath = sharedPath;
    }

    private static String resolvePath(String path) {
        File f = new File(path);
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            String msg = "Unable to return canonical path for: " + f;
            log.warn(msg, (Throwable)e);
            return f.getAbsolutePath();
        }
    }

    public boolean isMaster() {
        try {
            return this.clusterController == null ? true : this.clusterController.isMaster();
        }
        catch (IOException e) {
            log.warn("Could not get isMaster flag", (Throwable)e);
            return false;
        }
    }
}

