/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.jndi;

import com.day.crx.CRXModule;
import com.day.crx.CRXRepository;
import com.day.crx.License;
import com.day.crx.core.CRXRepositoryImpl;
import com.day.crx.core.config.CRXRepositoryConfig;
import java.io.File;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.Reference;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.jndi.BindableRepository;

class BindableCRXRepository
extends BindableRepository
implements CRXRepository {
    private static final long serialVersionUID = -251009581662504763L;

    protected BindableCRXRepository(Reference reference) throws RepositoryException {
        super(reference);
    }

    protected JackrabbitRepository createRepository() throws RepositoryException {
        Reference reference = this.getReference();
        RepositoryConfig config = CRXRepositoryConfig.create(reference.get("configFilePath").getContent().toString(), reference.get("repHomeDir").getContent().toString());
        return CRXRepositoryImpl.create(config);
    }

    public CRXModule getModule(String moduleName) {
        return ((CRXRepository)this.getRepository()).getModule(moduleName);
    }

    public CRXModule[] getModules() {
        return ((CRXRepository)this.getRepository()).getModules();
    }

    public void installModule(Session session, CRXModule module) throws AccessDeniedException, RepositoryException {
        ((CRXRepository)this.getRepository()).installModule(session, module);
    }

    public void uninstallModule(Session session, String moduleName) throws AccessDeniedException {
        ((CRXRepository)this.getRepository()).uninstallModule(session, moduleName);
    }

    public License getLicense() {
        return ((CRXRepository)this.getRepository()).getLicense();
    }

    public File getHomeDir() {
        return ((CRXRepository)this.getRepository()).getHomeDir();
    }
}

