/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.data.tar;

import com.day.crx.core.data.tar.TarDataRecord;
import com.day.crx.persistence.tar.TarSet;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.util.RepositoryLockMechanismFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.lang.ref.WeakReference;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.AbstractDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.FileDataRecord;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.util.CooperativeFileLock;
import org.apache.jackrabbit.core.util.RepositoryLockMechanism;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarDataStore
extends AbstractDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(TarDataStore.class);
    private static final String DIGEST = "SHA-1";
    static final int HASH_LENGTH = 20;
    private static final int DEFAULT_MIN_RECORD_LENGTH = 1024;
    private static final int DEFAULT_MIN_RECORD_LENGTH_LARGE = 131072;
    private static final String TMP = "tmp";
    private static final int DEFAULT_MAX_TAR_FILE_SIZE = 512;
    private static final int CLOSE_DELAY = 1000;
    private long minModifiedDate;
    private File directory;
    private String path;
    private int minRecordLength = 1024;
    private int minRecordLengthLarge = 131072;
    private TarSet tarset;
    protected Map<DataIdentifier, WeakReference<DataIdentifier>> inUse = Collections.synchronizedMap(new WeakHashMap());
    private RepositoryLockMechanism tarLock;
    private String tarLockClass = CooperativeFileLock.class.getName();
    private boolean tarReadonly;
    private int maxTarFileSize = 512;
    private ReopenLater reopenLater;
    private Object reopenLaterSync = new Object();
    private boolean closed;

    public synchronized void init(String homeDir) throws RepositoryException {
        if (this.path == null) {
            this.path = homeDir + "/repository/tarDatastore";
        }
        this.directory = new File(this.path);
        this.directory.mkdirs();
        this.reopenTarSet(true);
    }

    private synchronized void reopenTarSet(boolean forWriting) throws DataStoreException {
        if (this.closed) {
            return;
        }
        this.unlockAndCloseTarSet(forWriting);
        this.tarset = new TarSet();
        this.tarset.setLockClass(Noop.class.getName());
        this.tarset.setMaxFileSize(this.maxTarFileSize);
        if (forWriting) {
            try {
                this.tarLock = RepositoryLockMechanismFactory.createInstance(this.tarLockClass);
                this.tarLock.init(this.path);
                this.tarLock.acquire();
                this.tarReadonly = false;
            }
            catch (RepositoryException e) {
                this.tarReadonly = true;
            }
        } else {
            this.tarReadonly = true;
        }
        try {
            this.tarset.open(this.path, this.path, false, 0, this.tarReadonly ? "r" : "rw");
        }
        catch (IOException e) {
            throw new DataStoreException("Can not open tar set; readonly=" + this.tarReadonly, (Throwable)e);
        }
    }

    public synchronized DataRecord getRecordIfStored(DataIdentifier identifier) throws DataStoreException {
        String id = identifier.toString();
        int idx = id.indexOf(58);
        if (idx < 0) {
            return this.getRecordIfStored(identifier, true);
        }
        long length = Long.parseLong(id.substring(idx + 1));
        return this.getRecordIfStored(identifier, length >= (long)this.minRecordLengthLarge);
    }

    private DataRecord getRecordIfStored(DataIdentifier identifier, boolean tryLargeFirst) throws DataStoreException {
        DataRecord record = tryLargeFirst ? this.getRecordIfStoredLarge(identifier) : this.getRecordIfStoredSmall(identifier);
        if (record != null) {
            return record;
        }
        if (tryLargeFirst) {
            return this.getRecordIfStoredSmall(identifier);
        }
        return this.getRecordIfStoredLarge(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataRecord getRecordIfStoredLarge(DataIdentifier identifier) {
        File file = this.getFile(identifier);
        TarDataStore tarDataStore = this;
        synchronized (tarDataStore) {
            if (!file.exists()) {
                return null;
            }
            if (this.minModifiedDate != 0L && file.canWrite() && file.lastModified() < this.minModifiedDate) {
                file.setLastModified(System.currentTimeMillis());
            }
            this.usesIdentifier(identifier);
            return new FileDataRecord((AbstractDataStore)this, identifier, file);
        }
    }

    private DataRecord getRecordIfStoredSmall(DataIdentifier identifier) throws DataStoreException {
        NodeId uuid = this.getNodeId(identifier);
        try {
            IndexEntry entry = this.tarset.getIndexEntry(uuid, 0);
            if (entry == null) {
                return null;
            }
            InputStream in = this.tarset.getInputStream(entry.getUUID(), entry.getType());
            byte[] hash = new byte[20];
            for (int i = 0; i < 20; ++i) {
                hash[i] = (byte)in.read();
            }
            DataIdentifier rec = new DataIdentifier(TarDataStore.encodeHexString((byte[])hash));
            if (!this.getHash(rec).equals(this.getHash(identifier))) {
                return null;
            }
            return new TarDataRecord(this, identifier, this.tarset, entry);
        }
        catch (IOException e) {
            throw new DataStoreException("Error reading record: " + identifier, (Throwable)e);
        }
    }

    public synchronized DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        DataRecord record = this.getRecordIfStored(identifier);
        if (record == null) {
            if (this.tarReadonly) {
                for (int i = 0; i < 20; ++i) {
                    this.reopenTarSet(!this.tarReadonly);
                    record = this.getRecordIfStored(identifier);
                    if (record != null) break;
                    try {
                        Thread.sleep(Math.min(1, 100));
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (record == null) {
                throw new DataStoreException("Record not found: " + identifier);
            }
        }
        return record;
    }

    private void usesIdentifier(DataIdentifier identifier) {
        this.inUse.put(identifier, new WeakReference<DataIdentifier>(identifier));
    }

    public synchronized DataRecord addRecord(InputStream input) throws DataStoreException {
        int maxMemorySize = Math.max(0, this.minRecordLengthLarge);
        byte[] buffer = new byte[maxMemorySize];
        int pos = 0;
        int len = maxMemorySize;
        try {
            int l;
            while (pos < maxMemorySize && (l = input.read(buffer, pos, len)) >= 0) {
                pos += l;
                len -= l;
            }
        }
        catch (IOException e) {
            throw new DataStoreException("Could not read from stream", (Throwable)e);
        }
        if (pos < maxMemorySize) {
            byte[] data = new byte[pos];
            System.arraycopy(buffer, 0, data, 0, pos);
            return this.addRecordTar(data);
        }
        input = new SequenceInputStream(new ByteArrayInputStream(buffer, 0, pos), input);
        return this.addRecordFile(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataRecord addRecordTar(byte[] data) throws DataStoreException {
        MessageDigest digest = this.createMessageDigest();
        digest.update(data);
        byte[] digestBytes = digest.digest();
        DataIdentifier identifier = new DataIdentifier(TarDataStore.encodeHexString((byte[])digestBytes));
        NodeId id = this.getNodeId(identifier);
        try {
            IndexEntry entry = this.tarset.getIndexEntry(id, 0);
            if (entry == null) {
                if (this.tarReadonly) {
                    return this.addRecordFile(new ByteArrayInputStream(data));
                }
                byte[] hashAndData = new byte[20 + data.length];
                System.arraycopy(digestBytes, 0, hashAndData, 0, 20);
                System.arraycopy(data, 0, hashAndData, 20, data.length);
                this.tarset.append(id, 0, hashAndData);
                entry = this.tarset.getIndexEntry(id, 0);
                this.scheduleLater();
            } else {
                InputStream in;
                block9: {
                    DataRecord dataRecord;
                    block8: {
                        in = this.tarset.getInputStream(id, 0);
                        try {
                            for (int i = 0; i < 20; ++i) {
                                if (in.read() == (digestBytes[i] & 0xFF)) continue;
                                dataRecord = this.addRecordFile(new ByteArrayInputStream(data));
                                Object var11_12 = null;
                                break block8;
                            }
                            break block9;
                        }
                        catch (Throwable throwable) {
                            Object var11_14 = null;
                            in.close();
                            throw throwable;
                        }
                    }
                    in.close();
                    return dataRecord;
                }
                Object var11_13 = null;
                in.close();
            }
            identifier = new DataIdentifier(identifier + ":" + data.length);
            return new TarDataRecord(this, identifier, this.tarset, entry);
        }
        catch (IOException e) {
            throw new DataStoreException("Could not write to the tar set", (Throwable)e);
        }
    }

    private MessageDigest createMessageDigest() throws DataStoreException {
        try {
            return MessageDigest.getInstance(DIGEST);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DataStoreException("SHA-1 not available", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataRecord addRecordFile(InputStream input) throws DataStoreException {
        TarDataStore tarDataStore;
        block16: {
            File temporary = null;
            try {
                File file;
                temporary = this.newTemporaryFile();
                DataIdentifier tempId = this.createDataIdentifier(temporary.getName(), temporary.length());
                this.usesIdentifier(tempId);
                long length = 0L;
                MessageDigest digest = this.createMessageDigest();
                DigestOutputStream output = new DigestOutputStream(new FileOutputStream(temporary), digest);
                try {
                    length = IOUtils.copyLarge((InputStream)input, (OutputStream)output);
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    ((OutputStream)output).close();
                    throw throwable;
                }
                ((OutputStream)output).close();
                DataIdentifier identifier = new DataIdentifier(TarDataStore.encodeHexString((byte[])digest.digest()));
                tarDataStore = this;
                synchronized (tarDataStore) {
                    this.usesIdentifier(identifier);
                    file = this.getFile(identifier);
                    File parent = file.getParentFile();
                    if (!parent.isDirectory()) {
                        parent.mkdirs();
                    }
                    if (!file.exists()) {
                        temporary.renameTo(file);
                        if (!file.exists()) {
                            throw new IOException("Can not rename " + temporary.getAbsolutePath() + " to " + file.getAbsolutePath() + " (media read only?)");
                        }
                    } else {
                        long now = System.currentTimeMillis();
                        if (file.lastModified() < now) {
                            file.setLastModified(now);
                        }
                    }
                    if (!file.isFile()) {
                        throw new IOException("Not a file: " + file);
                    }
                    if (file.length() != length) {
                        throw new IOException("SHA-1 collision: " + file);
                    }
                }
                this.inUse.remove(tempId);
                tarDataStore = new FileDataRecord((AbstractDataStore)this, identifier, file);
                Object var16_16 = null;
                if (temporary == null) break block16;
                temporary.delete();
            }
            catch (IOException e) {
                try {
                    throw new DataStoreException("Could not add record", (Throwable)e);
                }
                catch (Throwable throwable) {
                    block17: {
                        Object var16_17 = null;
                        if (temporary == null) break block17;
                        temporary.delete();
                    }
                    throw throwable;
                }
            }
        }
        return tarDataStore;
    }

    private File getFile(DataIdentifier identifier) {
        this.usesIdentifier(identifier);
        String string = this.getHash(identifier);
        File file = this.directory;
        file = new File(file, string.substring(0, 2));
        file = new File(file, string.substring(2, 4));
        file = new File(file, string.substring(4, 6));
        return new File(file, string);
    }

    private NodeId getNodeId(DataIdentifier identifier) {
        String s = identifier.toString();
        int idx = s.indexOf(58);
        if (idx >= 0) {
            s = s.substring(0, idx);
        }
        StringBuffer buff = new StringBuffer(36);
        buff.append(s.substring(0, 8)).append('-').append(s.substring(8, 12)).append('-');
        buff.append(s.substring(12, 16)).append('-').append(s.substring(16, 20)).append('-');
        buff.append(s.substring(20, 32));
        return new NodeId(buff.toString());
    }

    private DataIdentifier getDataIdentifier(NodeId id, long length) {
        DataIdentifier identifier = new DataIdentifier(TarDataStore.encodeHexString((byte[])id.getRawBytes()));
        if (length > 0L) {
            identifier = new DataIdentifier(identifier.toString() + ":" + length);
        }
        return identifier;
    }

    private String getHash(DataIdentifier identifier) {
        String string = identifier.toString();
        int idx = string.indexOf(58);
        if (idx >= 0) {
            return string.substring(0, idx);
        }
        return string;
    }

    private File newTemporaryFile() throws IOException {
        if (!this.directory.isDirectory()) {
            this.directory.mkdirs();
        }
        return File.createTempFile(TMP, null, this.directory);
    }

    public synchronized void updateModifiedDateOnAccess(long before) {
        this.minModifiedDate = before;
    }

    public synchronized int deleteAllOlderThan(long min) {
        return this.deleteOlderRecursive(this.directory, min);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteOlderRecursive(File file, long min) {
        int count = 0;
        if (file.isFile() && file.exists() && file.canWrite()) {
            TarDataStore tarDataStore = this;
            synchronized (tarDataStore) {
                DataIdentifier id;
                String fileName = file.getName();
                if (file.lastModified() < min && !this.inUse.containsKey(id = new DataIdentifier(fileName))) {
                    file.delete();
                    ++count;
                }
            }
        }
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                count += this.deleteOlderRecursive(f, min);
            }
            TarDataStore tarDataStore = this;
            synchronized (tarDataStore) {
                if (file != this.directory && file.list().length == 0) {
                    file.delete();
                }
            }
        }
        return count;
    }

    private void listRecursive(List<File> list, File file) {
        for (File f : file.listFiles()) {
            if (f.isDirectory()) {
                this.listRecursive(list, f);
                continue;
            }
            list.add(f);
        }
    }

    public synchronized Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        ArrayList<File> files = new ArrayList<File>();
        this.listRecursive(files, this.directory);
        ArrayList<DataIdentifier> identifiers = new ArrayList<DataIdentifier>();
        for (File f : files) {
            String name = f.getName();
            if (name.startsWith(TMP)) continue;
            DataIdentifier id = this.createDataIdentifier(name, f.length());
            identifiers.add(id);
        }
        try {
            Iterator a = identifiers.iterator();
            this.reopenTarSet(!this.tarReadonly);
            Iterator<IndexEntry> indexEntryIterator = this.tarset.getIndex().getAllEntries(null);
            AbstractIteratorDecorator b = new AbstractIteratorDecorator(indexEntryIterator){

                public Object next() {
                    IndexEntry entry = (IndexEntry)super.next();
                    return TarDataStore.this.getDataIdentifier(entry.getUUID(), entry.getLength());
                }
            };
            return new IteratorChain(a, (Iterator)b);
        }
        catch (IOException e) {
            throw new DataStoreException("Error listing entries", (Throwable)e);
        }
    }

    public synchronized void clearInUse() {
        this.inUse.clear();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String directoryName) {
        this.path = directoryName;
    }

    public int getMinRecordLength() {
        return this.minRecordLength;
    }

    public void setMinRecordLength(int minRecordLength) {
        this.minRecordLength = minRecordLength;
    }

    public synchronized void close() throws DataStoreException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.tarset == null) {
            return;
        }
        this.unlockAndCloseTarSet(true);
    }

    private synchronized void unlockAndCloseTarSet(boolean releaseLock) throws DataStoreException {
        if (this.tarLock != null && releaseLock) {
            try {
                this.tarLock.release();
            }
            catch (RepositoryException e) {
                throw new DataStoreException("Could not close tar set " + this.tarset, (Throwable)e);
            }
            this.tarLock = null;
        }
        if (this.tarset != null) {
            try {
                this.tarset.close();
            }
            catch (IOException e) {
                throw new DataStoreException("Could not close tar set " + this.tarset, (Throwable)e);
            }
            this.tarset = null;
        }
    }

    private DataIdentifier createDataIdentifier(String hash, long length) {
        return new DataIdentifier(hash + ":" + length);
    }

    public String getTarLockClass() {
        return this.tarLockClass;
    }

    public void setTarLockClass(String tarLockClass) {
        this.tarLockClass = tarLockClass;
    }

    public int getMaxTarFileSize() {
        return this.maxTarFileSize;
    }

    public void setMaxTarFileSize(int maxTarFileSize) {
        this.maxTarFileSize = maxTarFileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleLater() {
        Object object = this.reopenLaterSync;
        synchronized (object) {
            if (this.reopenLater == null) {
                this.reopenLater = new ReopenLater();
                this.reopenLater.start();
            } else {
                this.reopenLater.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeScheduler() {
        Object object = this.reopenLaterSync;
        synchronized (object) {
            this.reopenLater = null;
        }
    }

    private class ReopenLater
    extends Thread {
        private long reopenIn = 1000L;

        private ReopenLater() {
        }

        void reset() {
            this.reopenIn = 1000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = TarDataStore.this.reopenLaterSync;
            synchronized (object) {
                do {
                    long r = this.reopenIn;
                    this.reopenIn = 0L;
                    try {
                        TarDataStore.this.reopenLaterSync.wait(r);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                } while (this.reopenIn != 0L);
                TarDataStore.this.removeScheduler();
            }
            try {
                TarDataStore.this.reopenTarSet(!TarDataStore.this.tarReadonly);
            }
            catch (DataStoreException e) {
                LOG.error("Can not re-open tar set", (Throwable)e);
            }
        }
    }

    public static class Noop
    implements RepositoryLockMechanism {
        public void acquire() throws RepositoryException {
        }

        public void release() {
        }

        public void init(String path) {
        }
    }
}

