/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.data.tar;

import com.day.crx.core.data.tar.TarDataStore;
import com.day.crx.persistence.tar.TarSet;
import com.day.crx.persistence.tar.index.IndexEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.core.data.AbstractDataRecord;
import org.apache.jackrabbit.core.data.AbstractDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStoreException;

public class TarDataRecord
extends AbstractDataRecord {
    private final TarSet tarset;
    private final IndexEntry entry;

    public TarDataRecord(TarDataStore store, DataIdentifier identifier, TarSet tarset, IndexEntry entry) {
        super((AbstractDataStore)store, identifier);
        this.tarset = tarset;
        this.entry = entry;
    }

    public long getLength() {
        return this.entry.getLength();
    }

    public InputStream getStream() throws DataStoreException {
        try {
            InputStream in = this.tarset.getInputStream(this.entry.getUUID(), this.entry.getType());
            for (int i = 0; i < 20; ++i) {
                in.read();
            }
            return in;
        }
        catch (IOException e) {
            throw new DataStoreException("Error opening input stream of " + this.entry, (Throwable)e);
        }
    }

    public long getLastModified() {
        String fileName = this.tarset.getDataFile(this.entry.getFileId()).getFileName();
        return new File(fileName).lastModified();
    }
}

