/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.data;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class TempFileCache {
    private final File directory;
    private final Set<String> toBeDeleted = new HashSet<String>();
    private long size;
    private LRUCache cache;

    public TempFileCache(String path, long size) {
        this.size = size;
        this.cache = new LRUCache(size);
        ArrayList<File> allFiles = new ArrayList<File>();
        this.directory = new File(path);
        Iterator it = FileUtils.iterateFiles((File)this.directory, null, (boolean)true);
        while (it.hasNext()) {
            File f = (File)it.next();
            allFiles.add(f);
        }
        Collections.sort(allFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                long l2;
                long l1 = o1.lastModified();
                return l1 < (l2 = o2.lastModified()) ? -1 : (l1 > l2 ? 1 : 0);
            }
        });
        for (File f : allFiles) {
            String name = f.getPath();
            if (name.startsWith(path)) {
                name = name.substring(path.length());
            }
            if (name.startsWith("/") || name.startsWith("\\")) {
                name = name.substring(1);
            }
            this.cache.put(name, name);
        }
    }

    public void close() {
        this.log("close");
        this.deleteOldFiles();
    }

    public synchronized InputStream getIfStored(String fileName) throws IOException {
        if (this.size == 0L) {
            return null;
        }
        this.toBeDeleted.remove(fileName);
        if (this.cache.get(fileName) != null) {
            File f = this.getFile(fileName);
            if (!f.exists()) {
                return null;
            }
            f.setLastModified(System.currentTimeMillis());
            this.log("cache hit " + fileName);
            return new BufferedInputStream(new FileInputStream(f));
        }
        this.log("cache miss " + fileName);
        return null;
    }

    public File getFile(String fileName) {
        return new File(this.directory, fileName);
    }

    public synchronized InputStream store(String fileName, InputStream in) throws IOException {
        if (this.size == 0L) {
            return in;
        }
        this.toBeDeleted.remove(fileName);
        File f = this.getFile(fileName);
        if (this.cache.get(fileName) != null) {
            f.setLastModified(System.currentTimeMillis());
            this.log("store " + fileName + " already exists");
            return in;
        }
        this.log("cache store " + fileName);
        f.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(f);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        out.close();
        this.cache.put(fileName, fileName);
        if (!f.exists()) {
            throw new FileNotFoundException(f.toString());
        }
        BufferedInputStream fin = new BufferedInputStream(new FileInputStream(f));
        return fin;
    }

    public boolean isStored(String fileName) {
        if (this.size == 0L) {
            return false;
        }
        this.toBeDeleted.remove(fileName);
        if (this.cache.get(fileName) != null) {
            File f = this.getFile(fileName);
            f.setLastModified(System.currentTimeMillis());
            this.log("cache hit " + fileName);
            return true;
        }
        this.log("cache miss " + fileName);
        return false;
    }

    public synchronized void store(String fileName) {
        if (this.size == 0L) {
            return;
        }
        this.toBeDeleted.remove(fileName);
        this.cache.put(fileName, fileName);
        this.updateLastModified(fileName);
    }

    private void deleteOldFiles() {
        for (String n : new ArrayList<String>(this.toBeDeleted)) {
            this.tryDelete(n);
        }
    }

    synchronized boolean tryDelete(String fileName) {
        this.log("cache delete " + fileName);
        File f = this.getFile(fileName);
        if (f.delete()) {
            this.toBeDeleted.remove(fileName);
            while ((f = f.getParentFile()) != this.directory && f.list().length <= 0) {
                f.delete();
            }
            return true;
        }
        this.toBeDeleted.add(fileName);
        return false;
    }

    long getFileSize(String fileName) {
        File f = this.getFile(fileName);
        if (!f.exists()) {
            throw new RuntimeException(new FileNotFoundException(f.getAbsolutePath()));
        }
        return f.length();
    }

    static int maxSizeElements(long bytes) {
        int count = (int)(bytes / 65535L);
        count = Math.max(1024, count);
        count = Math.min(65536, count);
        return count;
    }

    private void log(String s) {
    }

    public void updateLastModified(String fileName) {
        this.getFile(fileName).setLastModified(System.currentTimeMillis());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LRUCache
    extends LinkedHashMap<String, String> {
        private static final long serialVersionUID = 1L;
        private long currentSizeInBytes;
        private final long maxSizeInBytes;

        public LRUCache(long maxSizeInBytes) {
            super(TempFileCache.maxSizeElements(maxSizeInBytes), 0.75f, true);
            this.maxSizeInBytes = maxSizeInBytes;
        }

        @Override
        public String put(String key, String value) {
            long size = TempFileCache.this.getFileSize(key);
            this.currentSizeInBytes += size;
            return super.put(key, value);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            if (this.currentSizeInBytes < this.maxSizeInBytes || this.size() <= 1) {
                return false;
            }
            String fileName = eldest.getKey();
            long size = TempFileCache.this.getFileSize(fileName);
            TempFileCache.this.tryDelete(fileName);
            this.currentSizeInBytes -= size;
            return true;
        }
    }
}

