/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.data;

import com.day.crx.core.cluster.OutgoingCall;
import com.day.crx.core.data.CallFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.core.data.DataIdentifier;

class DataRecordInputStream
extends InputStream {
    private final DataIdentifier id;
    private final CallFactory factory;
    private long position;
    private byte[] buf;
    private int offset;
    private int length;
    private boolean eof;

    public DataRecordInputStream(DataIdentifier id, CallFactory factory) {
        this.id = id;
        this.factory = factory;
        this.buf = new byte[32768];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        while (!this.eof) {
            int avail = Math.min(this.length - this.offset, len);
            if (avail > 0) {
                System.arraycopy(this.buf, this.offset, b, off, avail);
                this.offset += avail;
                this.position += (long)avail;
                return avail;
            }
            int read = this.readBytes(this.id, this.position, this.buf);
            if (read == -1) {
                this.eof = true;
                continue;
            }
            this.offset = 0;
            this.length = read;
        }
        return -1;
    }

    public int read() throws IOException {
        while (!this.eof) {
            if (this.length - this.offset > 0) {
                int v = 0xFF & this.buf[this.offset++];
                ++this.position;
                return v;
            }
            int read = this.readBytes(this.id, this.position, this.buf);
            if (read == -1) {
                this.eof = true;
                continue;
            }
            this.offset = 0;
            this.length = read;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readBytes(DataIdentifier id, long offset, byte[] data) throws IOException {
        int n;
        OutgoingCall call = this.factory.newCall(1);
        try {
            DataOutput out = call.getOutput();
            out.writeUTF(id.toString());
            out.writeLong(offset);
            out.writeInt(data.length);
            DataInput in = call.getInput();
            int len = in.readInt();
            if (len > 0) {
                in.readFully(data, 0, len);
            }
            n = len;
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            call.release();
            throw throwable;
        }
        call.release();
        return n;
    }

    public long skip(long n) throws IOException {
        this.position += n;
        this.offset = (long)(this.length - this.offset) > n ? (this.offset += (int)n) : this.length;
        return n;
    }
}

