/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.data;

import com.day.crx.core.data.Backend;
import com.day.crx.core.data.CachingDataRecord;
import com.day.crx.core.data.TempFileCache;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.AbstractDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachingDataStore
extends AbstractDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(CachingDataStore.class);
    private static final String DIGEST = "SHA-1";
    private static final String DS_STORE = ".DS_Store";
    private int minRecordLength = 16384;
    private String repositoryHome;
    private String path;
    private File directory;
    private String config;
    private static final String TMP = "tmp";
    private long minModifiedDate;
    protected Map<DataIdentifier, WeakReference<DataIdentifier>> inUse = Collections.synchronizedMap(new WeakHashMap());
    private long cacheSize = 0x1000000000L;
    protected Backend backend;
    private TempFileCache cache;

    public void init(String homeDir) throws RepositoryException {
        File markerFile;
        this.repositoryHome = homeDir;
        if (this.path == null) {
            this.path = homeDir + "/repository/datastore";
        }
        this.directory = new File(this.path);
        try {
            CachingDataStore.mkdirs(this.directory);
        }
        catch (IOException e) {
            throw new DataStoreException("Could not create directory " + this.directory.getAbsolutePath(), (Throwable)e);
        }
        this.backend = this.createBackend();
        this.backend.init(this);
        this.cache = new TempFileCache(this.path, this.cacheSize);
        String markerFileName = this.getMarkerFile();
        if (markerFileName != null && !(markerFile = new File(this.path, markerFileName)).exists()) {
            this.loadFilesFromCache();
            try {
                markerFile.createNewFile();
            }
            catch (IOException e) {
                throw new DataStoreException("Could not create marker file " + markerFile.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    public String getRepositoryHome() {
        return this.repositoryHome;
    }

    /*
     * Loose catch block
     */
    private void loadFilesFromCache() throws RepositoryException {
        ArrayList<File> files = new ArrayList<File>();
        this.listRecursive(files, this.directory);
        long totalSize = 0L;
        for (File f : files) {
            totalSize += f.length();
        }
        long currentSize = 0L;
        long time = System.currentTimeMillis();
        for (File f : files) {
            long now = System.currentTimeMillis();
            if (now > time + 5000L) {
                LOG.info("Uploading {}/{}", (Object)currentSize, (Object)totalSize);
                time = now;
            }
            currentSize += f.length();
            String name = f.getName();
            if (name.startsWith(TMP) || name.endsWith(DS_STORE) || f.length() <= 0L) continue;
            BufferedInputStream in = null;
            in = new BufferedInputStream(new FileInputStream(f));
            this.addRecord(in);
            Object var16_8 = null;
            if (in == null) continue;
            try {
                ((InputStream)in).close();
                continue;
            }
            catch (IOException e) {
                throw new DataStoreException("Could not close file " + name, (Throwable)e);
            }
            {
                catch (IOException e) {
                    throw new DataStoreException("Could not init file " + name, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                var16_8 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        throw new DataStoreException("Could not close file " + name, (Throwable)e);
                    }
                }
                throw throwable;
            }
        }
        LOG.info("Uploaded");
    }

    private void listRecursive(List<File> list, File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.listRecursive(list, f);
                    continue;
                }
                list.add(f);
            }
        }
    }

    abstract Backend createBackend();

    abstract String getMarkerFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataRecord addRecord(InputStream input) throws DataStoreException {
        File temporary = null;
        try {
            try {
                temporary = this.newTemporaryFile();
                DataIdentifier tempId = new DataIdentifier(temporary.getName());
                this.usesIdentifier(tempId);
                long length = 0L;
                MessageDigest digest = MessageDigest.getInstance(DIGEST);
                DigestOutputStream output = new DigestOutputStream(new FileOutputStream(temporary), digest);
                try {
                    length = IOUtils.copyLarge((InputStream)input, (OutputStream)output);
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    ((OutputStream)output).close();
                    throw throwable;
                }
                ((OutputStream)output).close();
                DataIdentifier identifier = new DataIdentifier(CachingDataStore.encodeHexString((byte[])digest.digest()));
                long now = System.currentTimeMillis();
                Object object = this;
                synchronized (object) {
                    this.usesIdentifier(identifier);
                    String fileName = this.getFileName(identifier);
                    if (!this.cache.isStored(fileName)) {
                        File file = new File(this.directory, fileName);
                        File parent = file.getParentFile();
                        if (!parent.exists()) {
                            parent.mkdirs();
                        }
                        temporary.renameTo(file);
                        if (file.exists()) {
                            temporary = null;
                        }
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                        this.cache.store(fileName);
                        try {
                            this.backend.write(identifier, in, length);
                            Object var17_19 = null;
                        }
                        catch (Throwable throwable) {
                            Object var17_20 = null;
                            IOUtils.closeQuietly((InputStream)in);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)in);
                    }
                }
                this.inUse.remove(tempId);
                object = new CachingDataRecord(this, identifier, now, length);
                Object var20_22 = null;
                if (temporary == null) return object;
                temporary.delete();
                return object;
            }
            catch (NoSuchAlgorithmException e) {
                throw new DataStoreException("SHA-1 not available", (Throwable)e);
            }
            catch (IOException e) {
                throw new DataStoreException("Could not add record", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var20_23 = null;
            if (temporary == null) throw throwable;
            temporary.delete();
            throw throwable;
        }
    }

    private String getFileName(DataIdentifier identifier) {
        String name = identifier.toString();
        name = name.substring(0, 2) + "/" + name.substring(2, 4) + "/" + name.substring(4, 6) + "/" + name;
        return name;
    }

    private void usesIdentifier(DataIdentifier identifier) {
        this.inUse.put(identifier, new WeakReference<DataIdentifier>(identifier));
    }

    private File newTemporaryFile() throws IOException {
        return File.createTempFile(TMP, null, this.directory);
    }

    InputStream getStream(DataIdentifier identifier) throws DataStoreException {
        try {
            String fileName = this.getFileName(identifier);
            InputStream cached = this.cache.getIfStored(fileName);
            if (cached != null) {
                return cached;
            }
            InputStream in = this.backend.read(identifier);
            return this.cache.store(fileName, in);
        }
        catch (IOException e) {
            throw new DataStoreException("IO Exception: " + identifier, (Throwable)e);
        }
    }

    public boolean isCached(DataIdentifier identifier) {
        this.usesIdentifier(identifier);
        String fileName = this.getFileName(identifier);
        return this.cache.isStored(fileName);
    }

    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        return this.backend.getAllIdentifiers();
    }

    private void updateLastModified(DataIdentifier identifier) throws DataStoreException {
        if (this.minModifiedDate != 0L) {
            String fileName = this.getFileName(identifier);
            if (this.cache.isStored(fileName)) {
                this.cache.updateLastModified(fileName);
            }
            this.backend.updateLastModified(identifier);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataRecord getRecordIfStored(DataIdentifier identifier) throws DataStoreException {
        String fileName = this.getFileName(identifier);
        if (!this.isCached(identifier)) {
            if (!this.backend.exists(identifier)) {
                return null;
            }
            InputStream in = this.backend.read(identifier);
            InputStream inCache = null;
            try {
                try {
                    inCache = this.cache.store(fileName, in);
                }
                catch (IOException e) {
                    throw new DataStoreException("IO Exception: " + identifier, (Throwable)e);
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((InputStream)inCache);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((InputStream)inCache);
        }
        File f = this.cache.getFile(fileName);
        this.updateLastModified(identifier);
        return new CachingDataRecord(this, identifier, f.lastModified(), f.length());
    }

    public int deleteAllOlderThan(long min) throws DataStoreException {
        return 0;
    }

    public void updateModifiedDateOnAccess(long before) {
        this.minModifiedDate = before;
    }

    public DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        DataRecord record = this.getRecordIfStored(identifier);
        if (record == null) {
            throw new DataStoreException("Record not found: " + identifier);
        }
        return record;
    }

    public void clearInUse() {
        this.inUse.clear();
    }

    public void close() throws DataStoreException {
        this.cache.close();
        this.backend.close();
        this.cache = null;
    }

    public void setMinRecordLength(int minRecordLength) {
        this.minRecordLength = minRecordLength;
    }

    public int getMinRecordLength() {
        return this.minRecordLength;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public static void mkdirs(File dir) throws IOException {
        if (dir.exists()) {
            if (dir.isFile()) {
                throw new IOException("Can not create a directory because a file exists with the same name: " + dir.getAbsolutePath());
            }
        } else {
            boolean created = dir.mkdirs();
            if (!created) {
                throw new IOException("Could not create directory: " + dir.getAbsolutePath());
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

