/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.config;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ImportConfig;
import org.apache.jackrabbit.core.config.PersistenceManagerConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.config.WorkspaceSecurityConfig;
import org.apache.jackrabbit.core.fs.FileSystemFactory;
import org.apache.jackrabbit.core.query.QueryHandlerFactory;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.user.UserImporter;
import org.apache.jackrabbit.core.state.ISMLockingFactory;
import org.apache.jackrabbit.core.xml.AccessControlImporter;

public class CRXWorkspaceConfig
extends WorkspaceConfig {
    private static final WorkspaceSecurityConfig DEFAULT_WORKSPACE_CONFIG;
    private static final ImportConfig DEFAULT_IMPORT_CONFIG;
    private final boolean simpleLocking;

    public CRXWorkspaceConfig(String home, String name, boolean clustered, FileSystemFactory fsf, PersistenceManagerConfig pmc, QueryHandlerFactory qhf, ISMLockingFactory ismlf, WorkspaceSecurityConfig wsc, ImportConfig ic, boolean simpleLocking) {
        super(home, name, clustered, fsf, pmc, qhf, ismlf, wsc, ic);
        this.simpleLocking = simpleLocking;
    }

    public boolean isSimpleLocking() {
        return this.simpleLocking;
    }

    public WorkspaceSecurityConfig getSecurityConfig() {
        WorkspaceSecurityConfig config = super.getSecurityConfig();
        if (config == null) {
            config = DEFAULT_WORKSPACE_CONFIG;
        }
        return config;
    }

    public ImportConfig getImportConfig() {
        ImportConfig config = super.getImportConfig();
        if (config == null) {
            config = DEFAULT_IMPORT_CONFIG;
        }
        return config;
    }

    static {
        Properties params = new Properties();
        params.setProperty("omit-default-permission", "true");
        BeanConfig beanConfig = new BeanConfig(ACLProvider.class.getName(), params){
            {
                this.setValidate(false);
            }
        };
        DEFAULT_WORKSPACE_CONFIG = new WorkspaceSecurityConfig(beanConfig);
        params = new Properties();
        params.setProperty("importBehavior", "besteffort");
        ArrayList<BeanConfig> bcs = new ArrayList<BeanConfig>(2);
        bcs.add(new BeanConfig(AccessControlImporter.class.getName(), new Properties()));
        bcs.add(new BeanConfig(UserImporter.class.getName(), params));
        DEFAULT_IMPORT_CONFIG = new ImportConfig(bcs);
    }
}

