/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.config;

import com.day.crx.core.CRXSecurityManager;
import com.day.crx.core.CRXUserManagerImpl;
import com.day.crx.core.config.CRXClusterConfig;
import com.day.crx.core.config.CRXConfigurationParser;
import com.day.crx.core.config.ModuleConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.DataSourceConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.RepositoryConfigurationParser;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.config.SecurityManagerConfig;
import org.apache.jackrabbit.core.config.UserManagerConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.data.DataStoreFactory;
import org.apache.jackrabbit.core.fs.FileSystemFactory;
import org.apache.jackrabbit.core.query.QueryHandlerFactory;
import org.apache.jackrabbit.core.util.RepositoryLockMechanismFactory;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class CRXRepositoryConfig
extends RepositoryConfig {
    private static final String REPOSITORY_XML = "repository.xml";
    private static final SecurityManagerConfig DEFAULT_SECURITY_MANAGER_CONFIG;
    private ModuleConfig[] modules;
    private ImmutableConfig config;

    public CRXRepositoryConfig(String home, SecurityConfig sec, FileSystemFactory fsf, String workspaceDirectory, String workspaceConfigDirectory, String defaultWorkspace, int workspaceMaxIdleTime, Element template, VersioningConfig vc, QueryHandlerFactory qhf, CRXClusterConfig cc, DataStoreFactory dsf, RepositoryLockMechanismFactory rlf, ModuleConfig[] modules, DataSourceConfig dsc, ConnectionFactory cf, RepositoryConfigurationParser parser) {
        super(home, sec, fsf, workspaceDirectory, workspaceConfigDirectory, defaultWorkspace, workspaceMaxIdleTime, template, vc, qhf, (ClusterConfig)cc, dsf, rlf, dsc, cf, parser);
        this.modules = modules;
    }

    public CRXRepositoryConfig(String home, SecurityConfig sec, FileSystemFactory fsf, String workspaceDirectory, String workspaceConfigDirectory, String defaultWorkspace, int workspaceMaxIdleTime, Element template, VersioningConfig vc, QueryHandlerFactory qhf, CRXClusterConfig cc, DataStoreFactory dsf, RepositoryLockMechanismFactory rlf, DataSourceConfig dsc, ConnectionFactory cf, RepositoryConfigurationParser parser) {
        this(home, sec, fsf, workspaceDirectory, workspaceConfigDirectory, defaultWorkspace, workspaceMaxIdleTime, template, vc, qhf, cc, dsf, rlf, null, dsc, cf, parser);
    }

    public static RepositoryConfig create(String file, String home) throws ConfigurationException {
        URI uri = new File(file).toURI();
        return CRXRepositoryConfig.create(new InputSource(uri.toString()), home);
    }

    public static RepositoryConfig create(URI uri, String home) throws ConfigurationException {
        return CRXRepositoryConfig.create(new InputSource(uri.toString()), home);
    }

    public static RepositoryConfig create(InputStream input, String home) throws ConfigurationException {
        return CRXRepositoryConfig.create(new InputSource(input), home);
    }

    public static RepositoryConfig create(InputSource xml, String home) throws ConfigurationException {
        Properties variables = new Properties();
        variables.setProperty("rep.home", home);
        CRXConfigurationParser parser = new CRXConfigurationParser(variables);
        ImmutableConfig ic = new ImmutableConfig(xml, home);
        CRXRepositoryConfig config = parser.parseRepositoryConfig(ic.getInputSource());
        config.config = ic;
        config.init();
        return config;
    }

    public static CRXRepositoryConfig create(Properties variables) throws IOException, ConfigurationException {
        Properties copy = new Properties(variables);
        String home = copy.getProperty("rep.home");
        if (home == null) {
            home = copy.getProperty("org.apache.jackrabbit.repository.home", "repository");
            copy.setProperty("rep.home", home);
        }
        File dir = new File(home);
        String conf = copy.getProperty("rep.conf");
        if (conf == null) {
            conf = copy.getProperty("org.apache.jackrabbit.repository.conf");
        }
        if (conf == null) {
            conf = new File(dir, REPOSITORY_XML).getPath();
        }
        File xml = new File(conf);
        CRXConfigurationParser parser = new CRXConfigurationParser(variables);
        CRXRepositoryConfig config = parser.parseRepositoryConfig(new InputSource(xml.toURI().toString()));
        config.init();
        return config;
    }

    public ModuleConfig[] getModuleConfigs() {
        return this.modules;
    }

    public SecurityConfig getSecurityConfig() {
        SecurityConfig sc = super.getSecurityConfig();
        if (sc.getSecurityManagerConfig() == null) {
            sc = new SecurityConfig(sc.getAppName(), DEFAULT_SECURITY_MANAGER_CONFIG, sc.getAccessManagerConfig(), sc.getLoginModuleConfig());
        }
        return sc;
    }

    public CRXRepositoryConfig createClone() throws ConfigurationException {
        if (this.config == null) {
            throw new ConfigurationException("No immutable configuration");
        }
        return (CRXRepositoryConfig)CRXRepositoryConfig.create(this.config.getInputSource(), this.config.getHome());
    }

    static {
        Properties userMgrProps = new Properties();
        userMgrProps.setProperty("usersPath", "/home/users");
        userMgrProps.setProperty("groupsPath", "/home/groups");
        userMgrProps.setProperty("defaultDepth", "1");
        DEFAULT_SECURITY_MANAGER_CONFIG = new SecurityManagerConfig(new BeanConfig(CRXSecurityManager.class.getName(), new Properties()), null, null, new UserManagerConfig(new BeanConfig(CRXUserManagerImpl.class.getName(), userMgrProps)), null);
    }

    static class ImmutableConfig {
        private final String home;
        private final String xmlString;
        private final byte[] xmlBytes;
        private final String publicId;
        private final String systemId;
        private final String encoding;

        public ImmutableConfig(InputSource xml, String home) throws ConfigurationException {
            this.home = home;
            this.encoding = xml.getEncoding();
            this.publicId = xml.getPublicId();
            this.systemId = xml.getSystemId();
            try {
                Reader reader = xml.getCharacterStream();
                this.xmlString = reader == null ? null : IOUtils.toString((Reader)reader);
                InputStream in = xml.getByteStream();
                this.xmlBytes = in == null ? null : IOUtils.toByteArray((InputStream)in);
            }
            catch (IOException e) {
                throw new ConfigurationException("Error reading configuration: " + e, (Exception)e);
            }
        }

        public InputSource getInputSource() {
            InputSource s = new InputSource();
            s.setEncoding(this.encoding);
            s.setPublicId(this.publicId);
            s.setSystemId(this.systemId);
            if (this.xmlBytes != null) {
                s.setByteStream(new ByteArrayInputStream(this.xmlBytes));
            }
            if (this.xmlString != null) {
                s.setCharacterStream(new StringReader(this.xmlString));
            }
            return s;
        }

        public String getHome() {
            return this.home;
        }
    }
}

