/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.cluster;

import com.day.crx.core.cluster.TimeoutInputStream;
import com.day.crx.core.cluster.TimeoutOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TimeoutCounter {
    private static final TimeoutCounter instance = new TimeoutCounter();
    private boolean armed;
    private int counter;

    public static TimeoutCounter getInstance() {
        return instance;
    }

    public void arm(int count) {
        this.armed = true;
        this.counter = count;
    }

    public InputStream wrapIfArmed(InputStream in) {
        return this.armed ? new TimeoutInputStream(in) : in;
    }

    public OutputStream wrapIfArmed(OutputStream out) {
        return this.armed ? new TimeoutOutputStream(out) : out;
    }

    public void disarm() {
        this.armed = false;
    }

    public int getCount() {
        return this.counter;
    }

    public void tick() throws IOException {
        if (this.armed && this.counter-- <= 0) {
            throw new IOException("timeout simulated");
        }
    }
}

