/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.cluster;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ClosedInputStream;

public class TaggedDataInput
implements DataInput {
    private static final DataInput CLOSED = new DataInputStream((InputStream)ClosedInputStream.CLOSED_INPUT_STREAM);
    private char tag;
    private int rem;
    private DataInput in;
    private boolean eof;

    public TaggedDataInput(DataInput in) {
        this.in = in;
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        int total = 0;
        while (total < len) {
            this.checkTag('B', true);
            int avail = Math.min(this.rem, len - total);
            this.in.readFully(b, off + total, avail);
            total += avail;
            this.rem -= avail;
        }
    }

    public int skipBytes(int n) throws IOException {
        throw new IOException("Not implemented.");
    }

    public boolean readBoolean() throws IOException {
        this.checkTag('Z', false);
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        this.checkTag('B', true);
        return this.in.readByte();
    }

    public int readUnsignedByte() throws IOException {
        this.checkTag('B', true);
        return this.in.readUnsignedByte();
    }

    public short readShort() throws IOException {
        this.checkTag('S', false);
        return this.in.readShort();
    }

    public int readUnsignedShort() throws IOException {
        this.checkTag('S', false);
        return this.in.readUnsignedShort();
    }

    public char readChar() throws IOException {
        this.checkTag('C', false);
        return this.in.readChar();
    }

    public int readInt() throws IOException {
        this.checkTag('I', false);
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        this.checkTag('J', false);
        return this.in.readLong();
    }

    public float readFloat() throws IOException {
        this.checkTag('F', false);
        return this.in.readFloat();
    }

    public double readDouble() throws IOException {
        this.checkTag('D', false);
        return this.in.readDouble();
    }

    public String readLine() throws IOException {
        throw new IOException("Not implemented.");
    }

    public String readUTF() throws IOException {
        this.checkTag('U', false);
        return this.in.readUTF();
    }

    private void checkTag(char c, boolean hasLen) throws IOException {
        if (this.tag == c) {
            if (this.rem > 0) {
                return;
            }
        } else if (this.rem != 0) {
            throw new IOException("Current tag '" + this.tag + "' has " + this.rem + " unread entries.");
        }
        this.tag = (char)this.in.readUnsignedByte();
        if (this.tag != c) {
            throw new IOException("Expected tag: " + c + ", actual: " + this.tag);
        }
        if (hasLen) {
            this.rem = this.readVarInt();
        }
    }

    public int readVarInt() throws IOException {
        int n = 0;
        int rot = 0;
        for (int i = 0; i < 5; ++i) {
            int v = this.in.readUnsignedByte();
            n |= (v & 0x7F) << rot;
            if ((v & 0x80) == 0) break;
            rot += 7;
        }
        return n;
    }

    private void readTag() throws IOException {
        if (this.rem != 0) {
            this.in.skipBytes(this.rem);
            this.rem = 0;
        }
        this.tag = (char)this.in.readUnsignedByte();
        switch (this.tag) {
            case 'B': {
                this.in.skipBytes(this.readVarInt());
                break;
            }
            case 'C': {
                this.in.readChar();
                break;
            }
            case 'D': {
                this.in.readDouble();
                break;
            }
            case 'F': {
                this.in.readFloat();
                break;
            }
            case 'I': {
                this.in.readInt();
                break;
            }
            case 'J': {
                this.in.readLong();
                break;
            }
            case 'S': {
                this.in.readShort();
                break;
            }
            case 'U': {
                this.in.readUTF();
                break;
            }
            case 'X': {
                this.eof = true;
                break;
            }
            case 'Z': {
                this.in.readBoolean();
                break;
            }
            default: {
                throw new IOException("Unknown tag: " + this.tag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        if (this.eof) {
            return;
        }
        try {
            while (!this.eof) {
                this.readTag();
            }
        }
        finally {
            this.eof = true;
            this.in = CLOSED;
        }
    }
}

