/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.cluster;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;

class SocketInputStream
extends FilterInputStream {
    private static final String ECONNRESET = "Connection reset";

    protected SocketInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        try {
            return super.read();
        }
        catch (SocketException e) {
            if (e.getClass() == SocketException.class && ECONNRESET.equals(e.getMessage())) {
                throw new EOFException(ECONNRESET);
            }
            throw e;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return super.read(b, off, len);
        }
        catch (SocketException e) {
            if (e.getClass() == SocketException.class && ECONNRESET.equals(e.getMessage())) {
                throw new EOFException(ECONNRESET);
            }
            throw e;
        }
    }
}

