/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.cluster;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ClosedInputStream;

class ProxyDataInput
implements DataInput {
    private static final DataInput CLOSED = new DataInputStream((InputStream)ClosedInputStream.CLOSED_INPUT_STREAM);
    private DataInput in;

    public ProxyDataInput(DataInput in) {
        this.in = in;
    }

    public void readFully(byte[] b) throws IOException {
        if (this.in == null) {
            this.openIn();
        }
        this.in.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            this.openIn();
        }
        this.in.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        if (this.in == null) {
            this.openIn();
        }
        return this.in.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        if (this.in == null) {
            this.openIn();
        }
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        if (this.in == null) {
            this.openIn();
        }
        return this.in.readByte();
    }

    public int readUnsignedByte() throws IOException {
        if (this.in == null) {
            this.openIn();
        }
        return this.in.readUnsignedByte();
    }

    public short readShort() throws IOException {
        if (this.in == null) {
            this.openIn();
        }
        return this.in.readShort();
    }

    public int readUnsignedShort() throws IOException {
        if (this.in == null) {
            this.openIn();
        }
        return this.in.readUnsignedShort();
    }

    public char readChar() throws IOException {
        if (this.in == null) {
            this.openIn();
        }
        return this.in.readChar();
    }

    public int readInt() throws IOException {
        if (this.in == null) {
            this.openIn();
        }
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        if (this.in == null) {
            this.openIn();
        }
        return this.in.readLong();
    }

    public float readFloat() throws IOException {
        if (this.in == null) {
            this.openIn();
        }
        return this.in.readFloat();
    }

    public double readDouble() throws IOException {
        if (this.in == null) {
            this.openIn();
        }
        return this.in.readDouble();
    }

    public String readLine() throws IOException {
        if (this.in == null) {
            this.openIn();
        }
        return this.in.readLine();
    }

    public String readUTF() throws IOException {
        if (this.in == null) {
            this.openIn();
        }
        return this.in.readUTF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openIn() throws IOException {
        try {
            this.in = this.doOpenIn();
        }
        finally {
            if (this.in == null) {
                this.in = CLOSED;
            }
        }
    }

    protected DataInput doOpenIn() throws IOException {
        return null;
    }

    public void close() {
        if (this.in != CLOSED) {
            this.in = CLOSED;
        }
    }
}

