/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.cluster;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import com.day.crx.core.cluster.ClusterController;
import com.day.crx.core.cluster.ClusterNodeInfo;
import com.day.crx.core.cluster.DefaultIncomingCall;
import com.day.crx.core.cluster.DefaultOutgoingCall;
import com.day.crx.core.cluster.OutgoingCall;
import com.day.crx.core.cluster.RequestHandler;
import com.day.crx.core.cluster.SocketConnection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClusterSlave {
    private static final String MSG_OPERATION_TIMED_OUT = "Operation timed out";
    private static Logger log = LoggerFactory.getLogger(ClusterSlave.class);
    private static final long DEFAULT_AGE_MS = 10000L;
    private static final int MAX_QUEUE_SIZE;
    final ClusterController controller;
    private final InetAddress addr;
    private final int[] ports;
    private final int connectTimeout;
    private final int receiveTimeout;
    private final String slaveId;
    private final String clusterId;
    private final SynchronizedBoolean connected = new SynchronizedBoolean(false);
    private final SynchronizedBoolean stopped = new SynchronizedBoolean(false);
    private final SynchronizedBoolean blockIncoming = new SynchronizedBoolean(false);
    String masterId;
    private byte[] loginToken = new byte[20];
    SocketConnection connection;
    private final ExecutorService incomingCallExecutor;
    final SynchronizedBoolean masterDisconnected = new SynchronizedBoolean(false);
    private final Semaphore incomingQueueLimit = new Semaphore(MAX_QUEUE_SIZE);

    public ClusterSlave(ClusterController controller, InetAddress addr, int[] ports, final String slaveId, String clusterId, int connectTimeout, int receiveTimeout) {
        this.controller = controller;
        this.addr = addr;
        this.ports = ports;
        this.slaveId = slaveId;
        this.clusterId = clusterId;
        this.connectTimeout = connectTimeout;
        this.receiveTimeout = receiveTimeout;
        this.incomingCallExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName(String.format("Slave (%s) - Call Dispatcher", slaveId));
                return t;
            }
        });
    }

    public void start() throws IOException {
        IOException last = null;
        ArrayList<Integer> unresponsivePorts = new ArrayList<Integer>();
        ConnectException connectFailure = null;
        for (int port : this.ports) {
            try {
                while (!this.connect(this.addr, port)) {
                }
                return;
            }
            catch (UnknownHostException e) {
                throw e;
            }
            catch (ConnectException e) {
                connectFailure = e;
                unresponsivePorts.add(port);
            }
            catch (IOException e) {
                last = e;
            }
        }
        if (last != null) {
            throw last;
        }
        throw connectFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connect(InetAddress addr, int port) throws IOException {
        SocketConnection conn = null;
        try {
            Socket s = ClusterSlave.connect(addr, port, this.connectTimeout);
            s.setTcpNoDelay(true);
            s.setSoTimeout(this.receiveTimeout);
            conn = this.login(s, port);
            if (conn == null) {
                boolean bl = false;
                return bl;
            }
            this.connection = conn;
            this.connected.set(true);
            conn = null;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return true;
    }

    private static Socket connect(InetAddress addr, int port, int timeout) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(addr, port), timeout);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketConnection login(Socket s, int port) throws IOException {
        final SocketConnection conn = new SocketConnection(s);
        final AtomicBoolean isConnectedToMaster = new AtomicBoolean();
        Thread t = new Thread(new Runnable(){

            public void run() {
                ClusterSlave.this.receiveAndDispatch(conn, isConnectedToMaster);
            }
        });
        String name = String.format("Slave (%s) -> [%s:%d]", this.slaveId, this.addr.getHostAddress(), port);
        t.setName(name);
        t.setDaemon(true);
        t.start();
        DefaultOutgoingCall call = new DefaultOutgoingCall(conn, "", 0);
        call.setExecutionTimeout(this.connectTimeout);
        InetAddress bindaddr = this.controller.getBindAddress();
        try {
            DataOutput out = call.getOutput();
            out.writeUTF(this.slaveId);
            out.writeUTF(this.clusterId);
            out.writeUTF(this.controller.getOS());
            out.writeUTF(bindaddr != null ? bindaddr.getHostAddress() : "*");
            out.writeUTF(this.controller.getRepositoryHome().getAbsolutePath());
            boolean canBecomeMaster = this.controller.isMasterListenerStarted();
            out.writeBoolean(canBecomeMaster);
            DataInput in = call.getInput();
            boolean pleaseRetryLater = in.readBoolean();
            if (pleaseRetryLater) {
                SocketConnection socketConnection = null;
                return socketConnection;
            }
            this.masterId = in.readUTF();
            isConnectedToMaster.set(true);
            name = String.format("Slave (%s) -> Master (%s) [%s:%d]", this.slaveId, this.masterId, this.addr.getHostAddress(), port);
            t.setName(name);
            in.readFully(this.loginToken);
        }
        finally {
            call.release();
        }
        return conn;
    }

    void receiveAndDispatch(SocketConnection conn, AtomicBoolean isConnectedToMaster) {
        if (log.isDebugEnabled()) {
            conn.createBacklog(10000L);
        }
        boolean abnormalTermination = false;
        boolean restartAfterAbnormalTermination = false;
        block7: while (true) {
            try {
                DefaultIncomingCall call;
                while (!this.stopped.get() && (call = conn.receiveCall()) != null) {
                    if (this.blockIncoming.get()) continue;
                    try {
                        this.incomingQueueLimit.acquireUninterruptibly();
                        this.incomingCallExecutor.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    ClusterSlave.this.dispatch(call);
                                }
                                finally {
                                    ClusterSlave.this.incomingQueueLimit.release();
                                }
                            }
                        });
                        log.debug("Incoming call queue size: {}", (Object)(MAX_QUEUE_SIZE - this.incomingQueueLimit.availablePermits()));
                        continue block7;
                    }
                    catch (RejectedExecutionException e) {
                        break block7;
                    }
                }
                break;
            }
            catch (EOFException e) {
                log.debug("EOF from master.", (Throwable)e);
                break;
            }
            catch (SocketTimeoutException e) {
                log.warn("Read from master timed out.");
                abnormalTermination = true;
                break;
            }
            catch (SocketException e) {
                restartAfterAbnormalTermination = this.handleSocketException(e);
                abnormalTermination = true;
                break;
            }
            catch (IOException e) {
                log.warn("Unexpected I/O failure while receiving incoming calls.", (Throwable)e);
                abnormalTermination = true;
                break;
            }
        }
        conn.dumpBacklog();
        if (this.connected.get() && !this.masterDisconnected.set(true) && isConnectedToMaster.get() && !this.blockIncoming.get()) {
            this.controller.masterDisconnected(this.masterId, abnormalTermination, restartAfterAbnormalTermination);
        }
    }

    public OutgoingCall newCall(String target, int operation) throws IOException {
        return this.newCall(target, operation, false);
    }

    OutgoingCall newCall(String target, int operation, boolean oneWay) throws IOException {
        if (this.stopped.get()) {
            throw new IOException("Not connected.");
        }
        RequestHandler outc = new RequestHandler(){

            public byte[] sendRequest(String target, int operation, boolean oneWay, long timeoutMs, byte[] body) throws IOException {
                try {
                    return ClusterSlave.this.connection.sendRequest(target, operation, oneWay, timeoutMs, body);
                }
                catch (SocketException e) {
                    if (!ClusterSlave.this.masterDisconnected.set(true)) {
                        ClusterSlave.this.controller.masterDisconnected(ClusterSlave.this.masterId, false, false);
                    }
                    throw e;
                }
            }
        };
        return new DefaultOutgoingCall(outc, target, operation, oneWay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatch(DefaultIncomingCall call) {
        log.debug("Dispatching call from master on slave '{}': {}", (Object)this.slaveId, (Object)call);
        try {
            call.setCallerId(this.masterId);
            try {
                this.controller.dispatch(call);
            }
            finally {
                call.release();
            }
        }
        catch (Exception e) {
            log.warn("Error on dispatching request", (Throwable)e);
        }
    }

    public boolean stop() {
        if (this.stopped.set(true)) {
            return false;
        }
        this.incomingCallExecutor.shutdownNow();
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        return true;
    }

    public String getMasterId() {
        return this.masterId;
    }

    public InetSocketAddress getMasterSocketAddress() {
        return this.connection.getSocketAddress();
    }

    public InetAddress getMasterInetAddress() {
        return this.getMasterSocketAddress().getAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterNodeInfo getMasterInfo() throws IOException {
        OutgoingCall call = this.newCall("", 5);
        try {
            DataInput in = call.getInput();
            String os = in.readUTF();
            String hostname = in.readUTF();
            String repositoryHome = in.readUTF();
            ClusterNodeInfo clusterNodeInfo = new ClusterNodeInfo(this.masterId, os, hostname, repositoryHome);
            return clusterNodeInfo;
        }
        finally {
            call.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterNodeInfo[] getSlaveInfos() throws IOException {
        OutgoingCall call = this.newCall("", 6);
        try {
            DataInput in = call.getInput();
            ClusterNodeInfo[] result = new ClusterNodeInfo[in.readInt()];
            for (int i = 0; i < result.length; ++i) {
                String id = in.readUTF();
                String os = in.readUTF();
                String hostname = in.readUTF();
                String repositoryHome = in.readUTF();
                result[i] = new ClusterNodeInfo(id, os, hostname, repositoryHome);
            }
            ClusterNodeInfo[] clusterNodeInfoArray = result;
            return clusterNodeInfoArray;
        }
        finally {
            call.release();
        }
    }

    void blockIncomingCalls() {
        if (this.blockIncoming.set(true)) {
            return;
        }
        this.connection.disablePing();
    }

    private boolean handleSocketException(SocketException socketException) {
        boolean restartAfterAbnormalTermination;
        String exceptionMessage = socketException.getMessage();
        if (MSG_OPERATION_TIMED_OUT.equals(exceptionMessage)) {
            log.warn("Read from master timed out. Restart slave.");
            restartAfterAbnormalTermination = true;
        } else {
            log.warn("Unexpected Socket failure while receiving incoming calls.", (Throwable)socketException);
            restartAfterAbnormalTermination = false;
        }
        return restartAfterAbnormalTermination;
    }

    static {
        int queueSize = 1000;
        try {
            queueSize = Integer.parseInt(System.getProperty("crx.cluster.incoming.queue.size", String.valueOf(queueSize)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        MAX_QUEUE_SIZE = queueSize;
    }
}

