/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.cluster;

import com.day.text.Text;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterProperties {
    public static final String FILENAME = "cluster.properties";
    private static final String PN_ADDRESSES = "addresses";
    private static final String PN_MEMBERS = "members";
    private static final String PN_CLUSTER_ID = "cluster_id";
    private static final String[] PN_ALL = new String[]{"addresses", "members", "cluster_id"};
    private static Logger log = LoggerFactory.getLogger(ClusterProperties.class);
    private final File file;
    private final Properties props = new Properties();
    private transient SortedSet<String> members;

    public ClusterProperties(File file) {
        this.file = file;
    }

    public ClusterProperties(File file, Properties props) {
        this.file = file;
        for (String key : PN_ALL) {
            String value = props.getProperty(key);
            if (value == null) continue;
            this.props.setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        if (this.file.exists() && this.file.canRead()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));
            try {
                this.props.load(in);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    public String getClusterId() {
        return this.props.getProperty(PN_CLUSTER_ID);
    }

    public void setClusterId(String clusterId) {
        this.props.setProperty(PN_CLUSTER_ID, clusterId);
    }

    public String[] getAddresses() {
        String s = this.props.getProperty(PN_ADDRESSES);
        if (s != null) {
            return Text.explode((String)s, (int)44);
        }
        return new String[0];
    }

    public boolean addAddress(String address) {
        String[] addresses;
        for (String a : addresses = this.getAddresses()) {
            if (!address.equals(a)) continue;
            return false;
        }
        String[] tmp = new String[addresses.length + 1];
        System.arraycopy(addresses, 0, tmp, 0, addresses.length);
        tmp[addresses.length] = address;
        this.setAddresses(tmp);
        return true;
    }

    public void setAddresses(String[] addresses) {
        this.props.setProperty(PN_ADDRESSES, Text.implode((String[])addresses, (String)","));
    }

    public String[] getMembers() {
        return this.getMembersSet().toArray(new String[0]);
    }

    private synchronized SortedSet<String> getMembersSet() {
        String s;
        if (this.members == null) {
            this.members = new TreeSet<String>();
        }
        if ((s = this.props.getProperty(PN_MEMBERS)) != null) {
            for (String member : Text.explode((String)s, (int)44)) {
                this.members.add(member);
            }
        }
        return this.members;
    }

    public boolean addMember(String member) {
        SortedSet<String> members = this.getMembersSet();
        if (!members.add(member)) {
            return false;
        }
        this.props.setProperty(PN_MEMBERS, Text.implode((String[])members.toArray(new String[0]), (String)","));
        return true;
    }

    public void addAll(Properties props) {
        Enumeration<?> names = this.props.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            props.setProperty(key, this.props.getProperty(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.file));
        try {
            this.props.store(out, "Cluster properties");
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public void saveQuietly() {
        try {
            this.save();
        }
        catch (IOException e) {
            log.warn("Unable to store properties", (Throwable)e);
        }
    }
}

