/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.cluster;

import com.day.crx.core.cluster.DefaultOutgoingCall;
import com.day.crx.core.cluster.OutgoingCall;
import com.day.crx.core.cluster.RequestHandler;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ClosedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BroadcastCall
implements OutgoingCall {
    private static Logger log = LoggerFactory.getLogger(BroadcastCall.class);
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream(128);
    private DataOutputStream out;
    private DataInputStream in;
    private final RequestHandler[] recipients;
    private final String obj;
    private final int op;
    private boolean executed;

    public BroadcastCall(RequestHandler[] recipients, String obj, int op) {
        this.recipients = recipients;
        this.obj = obj;
        this.op = op;
    }

    public long getExecutionTimeout() {
        return 0L;
    }

    public void setExecutionTimeout(long timeoutMs) {
    }

    public DataOutput getOutput() {
        if (this.out == null) {
            this.out = new DataOutputStream(this.bos);
        }
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws IOException {
        if (this.executed) return;
        try {
            if (this.out != null) {
                this.out.flush();
            }
            byte[] data = this.bos.toByteArray();
            RequestHandler[] arr$ = this.recipients;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                block11: {
                    if (i$ >= len$) {
                        Object var11_10 = null;
                        this.executed = true;
                        return;
                    }
                    RequestHandler c = arr$[i$];
                    if (c != null) {
                        Object var9_8;
                        OutgoingCall call = null;
                        try {
                            try {
                                call = new DefaultOutgoingCall(c, this.obj, this.op, true);
                                call.getOutput().write(data);
                                call.execute();
                            }
                            catch (IOException e) {
                                log.warn("Error on notification", (Throwable)e);
                                var9_8 = null;
                                if (call != null) {
                                    call.release();
                                }
                                break block11;
                            }
                            var9_8 = null;
                            if (call == null) break block11;
                        }
                        catch (Throwable throwable) {
                            var9_8 = null;
                            if (call == null) throw throwable;
                            call.release();
                            throw throwable;
                        }
                        call.release();
                    }
                }
                ++i$;
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.executed = true;
            throw throwable;
        }
    }

    public DataInput getInput() {
        if (this.in == null) {
            this.in = new DataInputStream((InputStream)ClosedInputStream.CLOSED_INPUT_STREAM);
        }
        return this.in;
    }

    public boolean isBroadcast() {
        return true;
    }

    public boolean hasRecipients() {
        return this.recipients.length > 0;
    }

    public void release() {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("*");
        buf.append(this.obj);
        buf.append('#');
        buf.append(Integer.toString(this.op));
        return buf.toString();
    }
}

