/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.cluster;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Backlog<E> {
    private Node<E> head;
    private Node<E> tail;
    private final long ageMs;

    public Backlog(long ageMs) {
        this.ageMs = ageMs;
    }

    public void add(E value) {
        long nowMs = System.currentTimeMillis();
        while (this.head != null && nowMs - this.head.entry.timeMs >= this.ageMs) {
            this.head = this.head.next;
            if (this.head != null) continue;
            this.tail = null;
        }
        Node<E> e = new Node<E>(new Entry<E>(nowMs, value));
        if (this.head == null) {
            this.tail = e;
            this.head = this.tail;
        } else {
            this.tail.next = e;
            this.tail = e;
        }
    }

    public Iterator<Entry<E>> iterator() {
        return new IteratorImpl(this.head);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorImpl
    implements Iterator<Entry<E>> {
        private Node<E> current;

        public IteratorImpl(Node<E> current) {
            this.current = current;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Entry<E> next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Node e = this.current;
            this.current = this.current.next;
            return e.entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<E> {
        final Entry<E> entry;
        Node<E> next;

        Node(Entry<E> entry) {
            this.entry = entry;
            this.next = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<E> {
        public final long timeMs;
        public final E value;

        Entry(long timeMs, E value) {
            this.timeMs = timeMs;
            this.value = value;
        }
    }
}

