/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.backup.heapdump;

import com.day.crx.core.backup.heapdump.HeapDumper;
import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public final class SunHotSpotHeapDumper
implements HeapDumper {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final String DUMPHEAP_METHOD = "dumpHeap";
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    public boolean isAvailable() {
        try {
            ObjectInstance instance = this.server.getObjectInstance(new ObjectName(HOTSPOT_BEAN_NAME));
            return instance != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String hintMessage() {
        return "com.sun.management package not available in current JRE - try running the application in a Sun HotSpot VM.";
    }

    public void dump(File target) throws Exception {
        this.server.invoke(new ObjectName(HOTSPOT_BEAN_NAME), DUMPHEAP_METHOD, new Object[]{target.getPath(), true}, new String[]{String.class.getName(), Boolean.TYPE.getName()});
    }
}

