/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.backup.heapdump;

import com.day.crx.core.backup.heapdump.HeapDumper;
import java.io.File;
import java.lang.management.ManagementFactory;

public final class JMapHeapDumper
implements HeapDumper {
    private static final String JMAP_COMMAND = "jmap";
    private static final String PID_SEPARATOR = "@";
    private static final String DUMP_FILE_ARGUMENT_PATTERN = "-dump:file=%s";
    private static final int COMMAND_NOT_FOUND_CODE = 127;

    public boolean isAvailable() {
        try {
            return 127 != JMapHeapDumper.exec(JMAP_COMMAND);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String hintMessage() {
        return "`jmap` executable not found in the PATH, try to verify the JVM installation.";
    }

    public void dump(File target) throws Exception {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.substring(0, name.indexOf(PID_SEPARATOR));
        JMapHeapDumper.exec(JMAP_COMMAND, String.format(DUMP_FILE_ARGUMENT_PATTERN, target.getAbsolutePath()), pid);
    }

    private static int exec(String ... commands) throws Exception {
        Process jmapProcess = new ProcessBuilder(commands).start();
        jmapProcess.waitFor();
        return jmapProcess.exitValue();
    }
}

