/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.backup.heapdump;

import com.day.crx.core.backup.heapdump.HeapDumper;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;

public final class IbmHeapDumper
implements HeapDumper {
    private static final String DUMP_CLASS_NAME = "com.ibm.jvm.Dump";
    private static final String HEAPDUMP_METHOD = "HeapDump";
    private static final String HEAPDUMP_PREFIX = "heapdump";
    private Class<?> dumpClass;

    public IbmHeapDumper() {
        try {
            this.dumpClass = ClassLoader.getSystemClassLoader().loadClass(DUMP_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            this.dumpClass = null;
        }
    }

    public boolean isAvailable() {
        return this.dumpClass != null;
    }

    public String hintMessage() {
        return "com.ibm.jvm.Dump class not available in current JRE - try running the application in an IBM VM.";
    }

    public void dump(File target) throws Exception {
        Method heapDumpMethod = this.dumpClass.getDeclaredMethod(HEAPDUMP_METHOD, null);
        heapDumpMethod.invoke(null, (Object[])null);
        File currentWorkingDir = new File("").getAbsoluteFile();
        File[] files = currentWorkingDir.listFiles(new HeapDumpFilenameFiler());
        if (files != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                file.renameTo(target);
                return;
            }
        }
    }

    private static final class HeapDumpFilenameFiler
    implements FilenameFilter {
        private HeapDumpFilenameFiler() {
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(IbmHeapDumper.HEAPDUMP_PREFIX);
        }
    }
}

