/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.backup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.channels.FileChannel;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    static final boolean NIO_FILE_COPY = Boolean.valueOf(System.getProperty("com.day.crx.NioFileCopy", "false"));

    private FileUtil() {
    }

    public static long sumFileSizes(File file) {
        if (!file.exists()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        long size = 0L;
        File[] list = file.listFiles();
        if (list != null) {
            for (File f : list) {
                size += FileUtil.sumFileSizes(f);
            }
        }
        return size;
    }

    public static void writeZipStream(File directory, OutputStream out, FileCopyListener listener) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(out);
        zipOut.setLevel(1);
        FileUtil.addFiles(directory, directory, zipOut, listener);
        zipOut.finish();
        zipOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFiles(File base, File file, ZipOutputStream out, FileCopyListener listener) throws IOException {
        if (file.isDirectory()) {
            for (File f : FileUtil.listFiles(file)) {
                FileUtil.addFiles(base, f, out, listener);
            }
        } else {
            if (listener != null && listener.canSkip(file)) {
                return;
            }
            long total = file.length();
            FileInputStream in = new FileInputStream(file);
            try {
                int len;
                String path = file.getAbsolutePath().substring(base.getAbsolutePath().length());
                if (File.separatorChar == '\\') {
                    path = path.replace('\\', '/');
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (listener != null) {
                    listener.fileCopyStart(file, true);
                }
                ZipEntry ze = new ZipEntry(path);
                ze.setTime(file.lastModified());
                out.putNextEntry(ze);
                long pos = 0L;
                byte[] buf = new byte[4096];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    out.write(buf, 0, len);
                    pos += (long)len;
                    if (listener == null) continue;
                    listener.copied(pos, total);
                }
                if (listener != null) {
                    listener.fileCopyEnd();
                }
                out.closeEntry();
            }
            finally {
                ((InputStream)in).close();
            }
        }
    }

    public static void copy(File src, File dest, FileCopyListener listener, long onlyNewerThan, boolean onlyDifferent) throws IOException {
        if (listener != null && listener.canSkip(src)) {
            return;
        }
        if (!src.canRead()) {
            return;
        }
        if (src.isDirectory()) {
            boolean done;
            if (dest.isFile()) {
                throw new IOException("Can't copy a folder to a file");
            }
            if (!dest.exists() && !(done = dest.mkdirs())) {
                throw new IOException("Could not create the folder " + dest.getAbsolutePath());
            }
            if (!dest.canWrite()) {
                throw new IOException("Can't write to " + dest.getPath());
            }
            for (File child : FileUtil.listFiles(src)) {
                FileUtil.copy(child, new File(dest, child.getName()), listener, onlyNewerThan, onlyDifferent);
            }
        } else {
            File destParent;
            if (dest.isDirectory()) {
                destParent = dest;
                dest = new File(destParent, src.getName());
            } else {
                destParent = dest.getParentFile();
            }
            if (!destParent.canWrite()) {
                throw new IOException("can't write to " + destParent.getPath());
            }
            boolean copy = true;
            if (dest.exists()) {
                boolean isSameLength;
                boolean bl = isSameLength = dest.length() == src.length();
                if (onlyNewerThan != 0L) {
                    if (isSameLength) {
                        copy = src.lastModified() < onlyNewerThan ? false : !FileUtil.fileContentMatches(src, dest, listener);
                    }
                } else {
                    boolean isReadOnly = false;
                    if (listener != null) {
                        isReadOnly = listener.isReadOnly(src);
                    }
                    if (onlyDifferent && isSameLength && src.lastModified() == dest.lastModified()) {
                        boolean bl2 = isReadOnly ? false : (copy = !FileUtil.fileContentMatches(src, dest, listener));
                    }
                }
            }
            if (listener != null) {
                listener.fileCopyStart(src, false);
            }
            if (copy) {
                if (NIO_FILE_COPY) {
                    boolean success = FileUtil.copyFileFast(src, dest, listener);
                    if (!success) {
                        FileUtil.copyFileSlow(src, dest, listener);
                    }
                } else {
                    FileUtil.copyFileSlow(src, dest, listener);
                }
            } else if (listener != null) {
                listener.skip();
            }
            dest.setLastModified(src.lastModified());
            if (listener != null) {
                listener.fileCopyEnd();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean fileContentMatches(File src, File dest, FileCopyListener listener) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFileSlow(File src, File dest, FileCopyListener listener) throws IOException {
        FileInputStream fis = new FileInputStream(src);
        long total = src.length();
        try {
            FileOutputStream fos = new FileOutputStream(dest);
            try {
                byte[] buffer = new byte[8192];
                int read = 0;
                long pos = 0L;
                while ((read = fis.read(buffer)) > 0) {
                    fos.write(buffer, 0, read);
                    if (listener == null) continue;
                    listener.copied(pos += (long)read, total);
                }
            }
            catch (IOException e) {
                boolean bl;
                try {
                    if (listener != null) {
                        listener.onError(e);
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    fos.close();
                    throw throwable;
                }
                fos.close();
                fis.close();
                return bl;
            }
            fos.close();
        }
        finally {
            fis.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFileFast(File src, File dest, FileCopyListener listener) throws IOException {
        FileChannel input = new FileInputStream(src).getChannel();
        try {
            FileChannel output = new FileOutputStream(dest).getChannel();
            try {
                long len = input.size();
                output.transferFrom(input, 0L, len);
                listener.copied(len, len);
            }
            catch (IOException e) {
                boolean bl;
                try {
                    if (listener != null) {
                        listener.onError(e);
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    output.close();
                    throw throwable;
                }
                output.close();
                input.close();
                return bl;
            }
            output.close();
        }
        finally {
            input.close();
        }
        return true;
    }

    public static void deleteOld(File target, File source, String[] excludeSuffixes) throws IOException {
        if (target.isDirectory()) {
            if (source.exists() && source.isDirectory()) {
                for (File child : FileUtil.listFiles(target)) {
                    FileUtil.deleteOld(child, new File(source, child.getName()), excludeSuffixes);
                }
            } else {
                FileUtil.delete(target);
            }
        } else if (source.exists()) {
            if (source.isDirectory()) {
                FileUtil.delete(target);
            }
        } else {
            String n = target.getAbsolutePath();
            boolean delete = true;
            for (String s : excludeSuffixes) {
                if (!n.endsWith(s)) continue;
                delete = false;
                break;
            }
            if (delete) {
                FileUtil.delete(target);
            }
        }
    }

    public static void delete(File f) throws IOException {
        if (!f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            for (File child : FileUtil.listFiles(f)) {
                FileUtil.delete(child);
            }
        }
        if (!f.delete()) {
            throw new IOException("Unable to delete " + f.getPath());
        }
    }

    private static File[] listFiles(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException("Not a directory: " + dir.getAbsolutePath());
        }
        File[] list = dir.listFiles();
        if (list == null) {
            throw new IOException("Could not read directory " + dir.getAbsolutePath() + ", please check the file access rights.");
        }
        return list;
    }

    public static synchronized File createTempDirectory(String prefix, String suffix, File directory) throws IOException {
        if (prefix == null || prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short: " + prefix);
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (directory == null) {
            directory = new File(System.getProperty("java.io.tmpdir"));
        }
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            String name = prefix + Integer.toHexString(random.nextInt() & 0xFFFF) + suffix;
            File f = new File(directory, name);
            if (f.exists() || !f.mkdirs() || !f.isDirectory()) continue;
            return f;
        }
        throw new IOException("Could not create a temporary directory; prefix= " + prefix + " suffix=" + suffix + " directory=" + directory.getAbsolutePath());
    }

    public static String readableBytes(long bytes) {
        BigDecimal b = BigDecimal.valueOf(bytes);
        BigDecimal k = BigDecimal.valueOf(1024L);
        String unit = "bytes";
        if (b.compareTo(k) >= 0) {
            b = b.divide(k, 0, 5);
            unit = "kb";
        }
        if (b.compareTo(k) >= 0) {
            b = b.divide(k, 2, 5);
            unit = "mb";
        }
        if (b.compareTo(k) >= 0) {
            b = b.divide(k, 3, 5);
            unit = "gb";
        }
        return b + " " + unit;
    }

    public static String readableTime(long ms) {
        double s;
        if (ms == 0L) {
            return "0ms";
        }
        double t = (double)ms / 1000.0;
        StringBuilder sb = new StringBuilder();
        if (t >= 3600.0) {
            int h = (int)(t / 3600.0);
            t %= 3600.0;
            sb.append(h);
            sb.append("h");
        }
        if (t >= 60.0) {
            int m = (int)(t / 60.0);
            t %= 60.0;
            if (sb.length() > 0) {
                sb.append(" : ");
            }
            sb.append(m);
            sb.append("m");
        }
        if ((s = (double)((int)(t * 100.0)) / 100.0) > 0.0) {
            if (sb.length() > 0) {
                sb.append(" : ");
            }
            sb.append(s);
            sb.append("s");
        }
        return sb.toString();
    }

    public class FileCopyAdapter
    implements FileCopyListener {
        public void fileCopyStart(File src, boolean compress) {
        }

        public boolean canSkip(File src) {
            return false;
        }

        public boolean isReadOnly(File src) {
            return false;
        }

        public void copied(long pos, long total) {
        }

        public void skip() {
        }

        public void onError(IOException e) {
        }

        public void fileCopyEnd() {
        }

        public long totalBytesCopied() {
            return -1L;
        }

        public long totalBytesSkipped() {
            return -1L;
        }
    }

    public static interface FileCopyListener {
        public void fileCopyStart(File var1, boolean var2);

        public boolean canSkip(File var1);

        public boolean isReadOnly(File var1);

        public void copied(long var1, long var3);

        public void skip();

        public void onError(IOException var1);

        public void fileCopyEnd();

        public long totalBytesCopied();

        public long totalBytesSkipped();
    }
}

