/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.backup;

import com.day.crx.core.backup.BackupListener;
import com.day.crx.core.backup.BackupManager;

public class BackupBarrier {
    BarrierListener listener = new BarrierListener();

    public void close() {
        this.listener.close();
    }

    public void finalize() {
        this.close();
    }

    public void waitForBackup() {
        this.listener.waitForBackup();
    }

    static class BarrierListener
    implements BackupListener {
        private volatile boolean closed;
        private volatile boolean backupInProgress;

        BarrierListener() {
            BackupManager.getInstance().addListener(this);
        }

        public synchronized void beforeBackup() {
            this.backupInProgress = true;
        }

        public synchronized void afterBackup() {
            if (this.backupInProgress) {
                this.backupInProgress = false;
                this.notifyAll();
            }
        }

        public synchronized void close() {
            if (!this.closed) {
                this.closed = true;
                BackupManager.getInstance().removeListener(this);
            }
        }

        public synchronized void waitForBackup() {
            while (this.backupInProgress) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

