/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core;

import com.day.crx.core.CRXUserImpl;
import com.day.crx.core.ntlm.NTLMCredentialsAuthentication;
import java.security.Principal;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.user.MembershipCache;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.core.security.user.UserPerWorkspaceUserManager;

public class CRXUserManagerImpl
extends UserPerWorkspaceUserManager {
    private final Session session;

    public CRXUserManagerImpl(SessionImpl session, String s, Properties properties) throws RepositoryException {
        super(session, s, properties);
        this.session = session;
    }

    public CRXUserManagerImpl(SessionImpl session, String adminId, Properties config, MembershipCache mCache) throws RepositoryException {
        super(session, adminId, config, mCache);
        this.session = session;
    }

    public User createUser(String userID, String password, Principal principal, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        User user = super.createUser(userID, password, principal, intermediatePath);
        NTLMCredentialsAuthentication.passwordChanged(user, this.session.getValueFactory(), password);
        return user;
    }

    protected User doCreateUser(NodeImpl node) throws RepositoryException {
        return new CRXUserImpl(node, (UserManagerImpl)this);
    }
}

