/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core;

import com.day.crx.CRXSession;
import com.day.crx.core.CRXRepositoryImpl;
import com.day.crx.io.CRXExportHandler;
import com.day.crx.io.CRXImportHandler;
import com.day.crx.io.durbo.DurboExport;
import com.day.crx.io.durbo.DurboImport;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.AccessDeniedException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.XASessionImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRXSessionImpl
extends XASessionImpl
implements CRXSession {
    public static final String CLUSTER_SYNC_ON_REFRESH = "crx.clusterSyncOnRefresh";
    public static final String ENABLE_CLUSTER_SYNC_ON_REFRESH = "crx.enableClusterSyncOnRefresh";
    public static final String WORKSPACE_CHANGED_ATTRIBUTE = "crx.workspaceChanged";
    private static final boolean DEFAULT_CLUSTER_SYNC_ON_REFRESH = false;
    protected static Logger log = LoggerFactory.getLogger(CRXSessionImpl.class);
    private static boolean TRACK = Boolean.getBoolean("crx.debug.sessions");
    private static int trackNextCheck;
    private Tracker tracker;
    private boolean clusterSyncOnRefresh;
    private int clusterSyncNextCheck;

    protected CRXSessionImpl(RepositoryContext repositoryContext, Subject subject, WorkspaceConfig wspConfig) throws RepositoryException {
        super(repositoryContext, subject, wspConfig);
        if (trackNextCheck-- <= 0) {
            trackNextCheck = 10;
            TRACK = Boolean.getBoolean("crx.debug.sessions");
        }
        if (TRACK) {
            this.tracker = new Tracker();
        }
    }

    protected CRXSessionImpl(RepositoryContext repositoryContext, AuthContext lc, WorkspaceConfig wspConfig) throws RepositoryException {
        super(repositoryContext, lc, wspConfig);
        if (trackNextCheck-- <= 0) {
            trackNextCheck = 10;
            TRACK = Boolean.getBoolean("crx.debug.sessions");
        }
        if (TRACK) {
            this.tracker = new Tracker();
        }
    }

    public CRXExportHandler getExportHandler() throws RepositoryException {
        return new DurboExport((Session)this);
    }

    public CRXImportHandler getImportHandler() throws RepositoryException {
        return new DurboImport((Session)this);
    }

    public CRXSession getSession(String workspaceName) throws AccessDeniedException, NoSuchWorkspaceException, RepositoryException {
        CRXRepositoryImpl rep = (CRXRepositoryImpl)this.getRepository();
        if (workspaceName == null) {
            workspaceName = rep.getConfig().getDefaultWorkspaceName();
        }
        String oldWorkspaceName = this.getWorkspace().getName();
        Object attr = this.getAttribute(WORKSPACE_CHANGED_ATTRIBUTE);
        attr = attr == null || "".equals(attr) ? oldWorkspaceName : attr + "," + oldWorkspaceName;
        Subject newSubject = new Subject(this.subject.isReadOnly(), this.subject.getPrincipals(), this.subject.getPublicCredentials(), this.subject.getPrivateCredentials());
        CRXSessionImpl newSession = (CRXSessionImpl)rep.internalCreateSession(newSubject, workspaceName);
        newSession.setAttribute(WORKSPACE_CHANGED_ATTRIBUTE, attr);
        return newSession;
    }

    public synchronized void logout() {
        if (this.tracker != null) {
            this.tracker.close();
        }
        if (this.isLive()) {
            super.logout();
        }
    }

    public void save() throws RepositoryException {
        log.debug((Object)((Object)this) + ".save()");
        super.save();
    }

    protected String retrieveUserId(Subject subject, String workspaceName) throws RepositoryException {
        if (!subject.getPrincipals(SystemPrincipal.class).isEmpty()) {
            return new SystemPrincipal().getName();
        }
        return super.retrieveUserId(subject, workspaceName);
    }

    protected boolean clusterSyncOnRefresh() {
        Object attribute = this.getAttribute(ENABLE_CLUSTER_SYNC_ON_REFRESH);
        if (attribute != null) {
            this.clusterSyncOnRefresh = true;
            return this.clusterSyncOnRefresh;
        }
        if (this.clusterSyncNextCheck-- <= 0) {
            this.clusterSyncNextCheck = 10;
            String property = System.getProperty(CLUSTER_SYNC_ON_REFRESH);
            this.clusterSyncOnRefresh = property != null ? Boolean.valueOf(property) : false;
        }
        return this.clusterSyncOnRefresh;
    }

    private static class Tracker {
        private static AtomicInteger counter = new AtomicInteger();
        private static AtomicInteger openCount = new AtomicInteger();
        private int id = Tracker.open(counter.getAndIncrement());

        Tracker() {
        }

        private static int open(int id) {
            log.error("session# " + id + " opened (" + openCount.incrementAndGet() + ")", (Throwable)new Exception("Stack Trace"));
            return id;
        }

        synchronized void close() {
            if (this.id > 0) {
                log.error("session# " + this.id + " closed (" + openCount.decrementAndGet() + ")");
            }
            this.id = -1;
        }
    }
}

