/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core;

import com.day.crx.CRXModule;
import com.day.crx.CRXRepository;
import com.day.crx.CRXSession;
import com.day.crx.License;
import com.day.crx.cluster.ClusterRole;
import com.day.crx.core.CRXNamespaceRegistryImpl;
import com.day.crx.core.CRXSessionImpl;
import com.day.crx.core.CRXSystemSession;
import com.day.crx.core.IgnoringFileSystem;
import com.day.crx.core.RepositoryOutOfSyncRecovery;
import com.day.crx.core.backup.LowDiskSpaceMonitor;
import com.day.crx.core.backup.OutOfMemoryMonitor;
import com.day.crx.core.cluster.ClusterController;
import com.day.crx.core.config.CRXClusterConfig;
import com.day.crx.core.config.CRXRepositoryConfig;
import com.day.crx.core.config.CRXWorkspaceConfig;
import com.day.crx.core.config.ModuleConfig;
import com.day.crx.core.data.ClusterDataStore;
import com.day.crx.core.lock.CRXLockManagerImpl;
import com.day.crx.core.nodetype.CRXNodeTypeRegistry;
import com.day.crx.core.version.CRXVersionManagerImpl;
import com.day.crx.core.version.VersionLoader;
import com.day.crx.persistence.CRXPMContext;
import com.day.crx.persistence.tar.OptimizeThread;
import com.day.crx.persistence.tar.TarJournalPersistence;
import com.day.crx.persistence.tar.TarUtils;
import com.day.crx.query.lucene.LuceneHandler;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.security.auth.Subject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SearchManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.cluster.UpdateEventListener;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.PersistenceManagerConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemFactory;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.journal.Journal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.virtual.VirtualNodeTypeStateManager;
import org.apache.jackrabbit.core.observation.DelegatingObservationDispatcher;
import org.apache.jackrabbit.core.observation.ObservationDispatcher;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRXRepositoryImpl
extends RepositoryImpl
implements CRXRepository {
    public static final OutputStream DEV_NULL = new OutputStream(){

        public void write(int b) {
        }
    };
    static Logger log = LoggerFactory.getLogger(CRXRepositoryImpl.class);
    private static final String CRX_REPOSITORY_PROPERTIES = "crx_repository.properties";
    static final String CRX_ROLLBACK_TO = "rollback_to.txt";
    private final Map<String, CRXModule> modules = new LinkedHashMap<String, CRXModule>();
    private static RepositoryOutOfSyncRecovery outOfSyncRecovery;
    private License license;
    private FileSystem sharedFS;
    private String sharedPath;
    private boolean preferredMaster;
    private boolean sharedNothing;
    private boolean becomeMasterOnTimeout;
    private HashMap<String, CRXSystemSession> systemSessions;
    private ClusterController controller;
    private String bindAddress;
    private int[] portArray;
    private File rollbackToTransactionFile;
    private long rollbackToTransaction;
    private final Closeable emergencyCloser = new Closeable(){

        public void close() {
            CRXRepositoryImpl.this.shutdown();
        }
    };
    private static final Set<String> DEPRECATED_MODULES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryContext create(File dir, File xml) throws IOException, RepositoryException {
        if (!xml.exists()) {
            xml.getParentFile().mkdirs();
            Class<CRXRepositoryImpl> klass = CRXRepositoryImpl.class;
            InputStream input = klass.getResourceAsStream("repository.xml");
            try {
                FileOutputStream output = new FileOutputStream(xml);
                try {
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                }
                finally {
                    output.close();
                }
            }
            finally {
                input.close();
            }
        }
        CRXRepositoryConfig config = (CRXRepositoryConfig)CRXRepositoryConfig.create(xml.getPath(), dir.getPath());
        CRXRepositoryImpl repository = CRXRepositoryImpl.create(config);
        return repository.context;
    }

    public static CRXRepositoryImpl create(CRXRepositoryConfig config) throws RepositoryException {
        CRXRepositoryImpl rep = null;
        try {
            rep = new CRXRepositoryImpl(config);
        }
        catch (RepositoryException repoException) {
            CRXRepositoryImpl.handleOutOfSyncException(config, repoException);
            rep = new CRXRepositoryImpl(config.createClone());
        }
        if (rep.rollbackToTransaction()) {
            rep.shutdown();
            rep = new CRXRepositoryImpl(config.createClone());
        }
        return rep;
    }

    private static void handleOutOfSyncException(CRXRepositoryConfig config, RepositoryException repoException) throws RepositoryException {
        CRXClusterConfig clusterConfig = (CRXClusterConfig)config.getClusterConfig();
        if (clusterConfig != null && !clusterConfig.isOutOfSyncRecoveryEnabled()) {
            throw repoException;
        }
        if (outOfSyncRecovery == null) {
            outOfSyncRecovery = new RepositoryOutOfSyncRecovery();
        }
        outOfSyncRecovery.handleOutOfSyncException(repoException, config.getHomeDir());
    }

    public static RepositoryImpl create(RepositoryConfig config) throws RepositoryException {
        if (config instanceof CRXRepositoryConfig) {
            return CRXRepositoryImpl.create((CRXRepositoryConfig)config);
        }
        return RepositoryImpl.create((RepositoryConfig)config);
    }

    protected CRXRepositoryImpl(RepositoryConfig config) throws RepositoryException {
        super(config);
        Journal j;
        LowDiskSpaceMonitor.getInstance().register(this.emergencyCloser, 30);
        this.context.getExecutor().scheduleAtFixedRate(this.createMonitoringTask(), 1L, 1L, TimeUnit.SECONDS);
        this.installModules(this.getConfig());
        ClusterNode c = this.context.getClusterNode();
        if (c != null && (j = c.getJournal()) instanceof ClusterRole) {
            ClusterRole role = (ClusterRole)j;
            this.setDescriptor("crx.cluster.preferredMaster", Boolean.toString(role.isPreferredMaster()));
        }
        if (this.controller != null && this.preferredMaster) {
            log.info("Become master: " + this.controller.getRepositoryHome());
            try {
                this.controller.becomeMaster();
            }
            catch (Exception e) {
                log.error("Could not become master: " + e.toString(), (Throwable)e);
            }
        }
        this.setDescriptor("crx.cluster.master", Boolean.toString(this.getClusterMasterFlag()));
    }

    private void rollbackToTransactionInit() {
        this.rollbackToTransactionFile = new File(this.getHomeDir(), CRX_ROLLBACK_TO);
        if (!this.rollbackToTransactionFile.exists()) {
            return;
        }
        try {
            String tx = FileUtils.readFileToString((File)this.rollbackToTransactionFile).trim();
            if (tx != null && tx.length() > 0) {
                this.rollbackToTransaction = TarUtils.convertTransaction(tx);
            }
        }
        catch (IOException e) {
            log.warn("Rollback: error reading file " + this.rollbackToTransactionFile.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rollbackToTransaction() {
        if (this.rollbackToTransaction == 0L) {
            return false;
        }
        try {
            log.info("Rollback to " + TarUtils.getTransactionString(this.rollbackToTransaction));
            OptimizeThread.getInstance().setSkipOptimization(true);
            TarJournalPersistence p = TarJournalPersistence.getInstance(this.getHomeDir().getCanonicalPath());
            p.rollbackWorkspaces(this.rollbackToTransaction);
            long revision = p.getRevisionForTransaction(this.rollbackToTransaction);
            if (revision == -1L) {
                log.info("Revision not found");
            } else {
                log.info("Rollback to revision " + revision);
                this.rollbackIndexes(revision);
            }
            p.rollbackJournal(this.rollbackToTransaction);
        }
        catch (Exception e) {
            log.warn("Rollback failed", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            log.info("Rollback completed");
            OptimizeThread.getInstance().setSkipOptimization(false);
        }
        this.rollbackToTransactionFile.delete();
        return true;
    }

    private void rollbackIndexes(long revision) throws RepositoryException, IOException, JournalException {
        SearchManager lastSearchManager = null;
        for (String wspName : this.getWorkspaceNames()) {
            RepositoryImpl.WorkspaceInfo info = this.getWorkspaceInfo(wspName);
            if (!(info instanceof CRXWorkspaceInfo)) {
                throw new RepositoryException("Workspace info is not of type CRXWorkspaceInfo");
            }
            CRXWorkspaceInfo wspInfo = (CRXWorkspaceInfo)info;
            SearchManager searchManager = wspInfo.getSearchManager();
            if (searchManager == null) {
                log.info("No search index configured for workspace {}. Nothing to roll back", (Object)wspName);
                continue;
            }
            lastSearchManager = searchManager;
            log.info("performing rollback to revision {} on workspace {}", (Object)revision, (Object)wspName);
            this.doIndexRollback(searchManager.getQueryHandler(), revision, wspName);
        }
        if (lastSearchManager == null) {
            return;
        }
        QueryHandler handler = lastSearchManager.getQueryHandler().getContext().getParentHandler();
        if (handler == null) {
            log.info("No search index configured for version storage. Nothing to roll back");
            return;
        }
        log.info("performing rollback to revision {} on version storage", (Object)revision);
        this.doIndexRollback(handler, revision, null);
    }

    private void doIndexRollback(QueryHandler handler, long revision, String workspaceName) throws RepositoryException, IOException, JournalException {
        if (!(handler instanceof LuceneHandler)) {
            throw new RepositoryException("Cannot perform rollback. QueryHandler is not of type " + LuceneHandler.class.getSimpleName());
        }
        ((LuceneHandler)handler).rollbackToRevision(this.getClusterNode(), revision, workspaceName);
    }

    private Runnable createMonitoringTask() {
        return new Runnable(){

            public void run() {
                try {
                    OutOfMemoryMonitor.getInstance().checkAvailableMemory();
                    LowDiskSpaceMonitor.getInstance().checkDiskSpace();
                }
                catch (IOException e) {
                    log.warn("Unexpected exception while monitoring: ", (Throwable)e);
                }
            }
        };
    }

    protected void initStartupWorkspaces() throws RepositoryException {
        super.initStartupWorkspaces();
    }

    public Value[] getDescriptorValues(String key) {
        this.updateClusterMasterFlag(key);
        return super.getDescriptorValues(key);
    }

    public Value getDescriptorValue(String key) {
        this.updateClusterMasterFlag(key);
        return super.getDescriptorValue(key);
    }

    public String getDescriptor(String key) {
        this.updateClusterMasterFlag(key);
        return super.getDescriptor(key);
    }

    private void updateClusterMasterFlag(String key) {
        if ("crx.cluster.master".equals(key)) {
            boolean masterFlag = this.getClusterMasterFlag();
            try {
                if (super.getDescriptorValue(key).getBoolean() == masterFlag) {
                    return;
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            super.setDescriptor(key, ValueFactoryImpl.getInstance().createValue(masterFlag));
        }
    }

    private boolean getClusterMasterFlag() {
        Journal j;
        boolean masterFlag = true;
        ClusterNode c = this.context.getClusterNode();
        if (c != null && (j = c.getJournal()) instanceof ClusterRole) {
            masterFlag = ((ClusterRole)j).isMaster();
        }
        return masterFlag;
    }

    private boolean detectCluster() throws RepositoryException {
        CRXClusterConfig cc = (CRXClusterConfig)this.repConfig.getClusterConfig();
        if (cc == null) {
            return false;
        }
        this.sharedPath = cc.getSharedPath();
        this.preferredMaster = cc.isPreferredMaster();
        this.bindAddress = cc.getBindAddress();
        String portList = cc.getPortList();
        if (portList != null && portList.trim().length() > 0) {
            this.portArray = com.day.crx.cluster.ClusterController.parsePortList(portList);
        }
        this.sharedNothing = cc.isSharedNothing();
        this.becomeMasterOnTimeout = cc.isBecomeMasterOnTimeout();
        if (this.sharedPath == null && !this.sharedNothing) {
            return false;
        }
        FileSystemFactory fsf = cc.getClusterFileSystemFactory();
        if (fsf != null) {
            this.sharedFS = fsf.getFileSystem();
        } else if (this.sharedPath != null) {
            try {
                String sharedFileSystem = LocalFileSystem.class.getName();
                Properties p = new Properties();
                p.setProperty("path", this.sharedPath);
                BeanConfig config = new BeanConfig(sharedFileSystem, p);
                FileSystem sharedFS = (FileSystem)config.newInstance(FileSystem.class);
                sharedFS.init();
                this.sharedFS = sharedFS;
            }
            catch (FileSystemException e) {
                String msg = "Unable to create file system on shared path: " + this.sharedPath;
                throw new RepositoryException(msg, (Throwable)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRXModule getModule(String name) {
        Map<String, CRXModule> map = this.modules;
        synchronized (map) {
            return this.modules.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRXModule[] getModules() {
        Map<String, CRXModule> map = this.modules;
        synchronized (map) {
            return this.modules.values().toArray(new CRXModule[this.modules.size()]);
        }
    }

    private void installModules(RepositoryConfig config) {
        if (!(config instanceof CRXRepositoryConfig)) {
            log.debug("loadModules: Repository not configured with a CRXRepositoryConfig instance");
            return;
        }
        ModuleConfig[] moduleConfigs = ((CRXRepositoryConfig)config).getModuleConfigs();
        if (moduleConfigs == null || moduleConfigs.length == 0) {
            log.debug("loadModules: No modules configured");
            return;
        }
        for (ModuleConfig moduleConfig : moduleConfigs) {
            String moduleName = moduleConfig.getClassName();
            if (DEPRECATED_MODULES.contains(moduleName)) {
                log.warn("Ignoring deprecated module {}", (Object)moduleConfig);
                continue;
            }
            try {
                CRXModule module = (CRXModule)moduleConfig.newInstance(CRXModule.class);
                moduleName = module.getName();
                this.installModuleInternal(module);
            }
            catch (ClassCastException cce) {
                log.error("loadModules: Cannot load module " + moduleName + ", not a CRXModule", (Throwable)cce);
            }
            catch (ConfigurationException ce) {
                log.error("loadModules: Cannot configure module " + moduleName, (Throwable)ce);
            }
            catch (RepositoryException re) {
                log.error("loadModules: Cannot initialize module " + moduleName, (Throwable)re);
            }
            catch (Exception e) {
                log.error("loadModules: Module " + moduleName + " cannot be installed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopModules() {
        Map<String, CRXModule> map = this.modules;
        synchronized (map) {
            Iterator<CRXModule> iter = this.modules.values().iterator();
            while (iter.hasNext()) {
                CRXModule mod = iter.next();
                mod.stop();
                log.info("Module {} stopped", (Object)mod.getName());
                iter.remove();
            }
        }
    }

    public void installModule(Session session, CRXModule module) throws RepositoryException {
        if (module.getName() == null || module.getName().length() == 0) {
            throw new IllegalArgumentException("Module name must not be empty or null");
        }
        if (session == null) {
            throw new NullPointerException("session");
        }
        this.installModuleInternal(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installModuleInternal(CRXModule module) throws RepositoryException {
        String moduleName = module.getName();
        Map<String, CRXModule> map = this.modules;
        synchronized (map) {
            if (this.modules.containsKey(moduleName)) {
                throw new IllegalArgumentException("Module with name " + moduleName + " already installed");
            }
            try {
                module.start((CRXSession)this.internalGetSystemSession(this.repConfig.getDefaultWorkspaceName()));
                this.modules.put(moduleName, module);
                log.info("Module {} installed", (Object)moduleName);
            }
            catch (RepositoryException re) {
                throw re;
            }
            catch (Throwable e) {
                throw new RepositoryException("Cannot install module " + module.getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallModule(Session session, String moduleName) throws AccessDeniedException {
        CRXModule module;
        if (moduleName == null || moduleName.length() == 0) {
            log.debug("uninstallModule: Module name is empty, cannot uninstall");
            return;
        }
        if (session == null) {
            throw new NullPointerException("session");
        }
        Map<String, CRXModule> map = this.modules;
        synchronized (map) {
            module = this.modules.remove(moduleName);
        }
        if (module != null) {
            try {
                module.stop();
            }
            catch (Exception e) {
                log.error("Unexpected error stopping module " + moduleName, (Throwable)e);
            }
            log.info("Module {} uninstalled", (Object)moduleName);
        } else {
            log.debug("Module {} not installed", (Object)moduleName);
        }
    }

    protected VirtualNodeTypeStateManager getVirtualNodeTypeStateManager() throws RepositoryException {
        try {
            Field f = RepositoryImpl.class.getDeclaredField("virtNTMgr");
            f.setAccessible(true);
            return (VirtualNodeTypeStateManager)f.get((Object)this);
        }
        catch (Exception e) {
            String msg = "Unable to retrieve 'virtNTMgr' field.";
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    protected DelegatingObservationDispatcher getDelegatingDispatcher() throws RepositoryException {
        try {
            Field f = RepositoryImpl.class.getDeclaredField("delegatingDispatcher");
            f.setAccessible(true);
            return (DelegatingObservationDispatcher)f.get((Object)this);
        }
        catch (Exception e) {
            String msg = "Unable to retrieve 'delegatingDispatcher' field.";
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public synchronized CRXSystemSession internalGetSystemSession(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        CRXSystemSession ses;
        if (this.systemSessions == null) {
            this.systemSessions = new HashMap();
        }
        if ((ses = this.systemSessions.get(workspaceName)) == null) {
            ses = CRXSystemSession.create(this.context, this.getWorkspaceInfo(workspaceName).getConfig());
            this.systemSessions.put(workspaceName, ses);
        }
        return ses;
    }

    protected InternalVersionManagerImpl createVersionManager(VersioningConfig vConfig, DelegatingObservationDispatcher delegatingDispatcher) throws RepositoryException {
        PersistenceManager pm;
        FileSystem fs = vConfig.getFileSystem();
        try {
            pm = (PersistenceManager)vConfig.getPersistenceManagerConfig().newInstance(PersistenceManager.class);
            pm.init(this.createPMContext(vConfig.getHomeDir(), fs, false));
        }
        catch (Exception e) {
            String msg = "Cannot instantiate persistence manager " + vConfig.getPersistenceManagerConfig().getClassName();
            throw new RepositoryException(msg, (Throwable)e);
        }
        ISMLocking ismLocking = vConfig.getISMLocking();
        return new CRXVersionManagerImpl(pm, fs, this.context.getNodeTypeRegistry(), delegatingDispatcher, SYSTEM_ROOT_NODE_ID, VERSION_STORAGE_NODE_ID, ACTIVITIES_NODE_ID, this.context.getItemStateCacheFactory(), ismLocking, this.nodeIdFactory);
    }

    protected PMContext createPMContext(File homeDir, FileSystem fs, boolean isWorkspace) {
        CRXPMContext pmContext = new CRXPMContext(homeDir, fs, this.context.getRootNodeId(), (NamespaceRegistry)this.context.getNamespaceRegistry(), this.context.getNodeTypeRegistry(), this.context.getDataStore(), this.context.getRepositoryStatistics(), this.sharedPath, isWorkspace, this.preferredMaster, this.sharedNothing);
        ClusterConfig cc = this.repConfig.getClusterConfig();
        if (cc instanceof CRXClusterConfig) {
            pmContext.setCRXClusterConfig((CRXClusterConfig)cc);
        }
        return pmContext;
    }

    protected SessionImpl createSessionInstance(AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        return new CRXSessionImpl(this.context, loginContext, wspConfig);
    }

    protected SessionImpl createSessionInstance(Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        return new CRXSessionImpl(this.context, subject, wspConfig);
    }

    protected SessionImpl internalCreateSession(Subject subject, String wsName) throws AccessDeniedException, RepositoryException {
        return super.createSession(subject, wsName);
    }

    protected SessionImpl internalCreateSession(AuthContext ctx, String wsName) throws AccessDeniedException, RepositoryException {
        return super.createSession(ctx, wsName);
    }

    protected NamespaceRegistryImpl createNamespaceRegistry() throws RepositoryException {
        this.detectCluster();
        FileSystem fs = this.context.getFileSystem();
        if (this.sharedFS != null && !this.sharedNothing) {
            fs = new IgnoringFileSystem(this.sharedFS);
        }
        return new CRXNamespaceRegistryImpl(fs);
    }

    protected NodeTypeRegistry createNodeTypeRegistry() throws RepositoryException {
        FileSystem fs = this.context.getFileSystem();
        if (this.sharedFS != null && !this.sharedNothing) {
            fs = new IgnoringFileSystem(this.sharedFS);
        }
        return CRXNodeTypeRegistry.create((NamespaceRegistry)this.context.getNamespaceRegistry(), fs);
    }

    protected ClusterNode createClusterNode() throws RepositoryException {
        ClusterNode clusterNode = super.createClusterNode();
        try {
            this.rollbackToTransactionInit();
            this.controller = ClusterController.getInstance(this.getHomeDir(), this.repConfig.getClusterConfig().getId());
            if (this.rollbackToTransaction != 0L) {
                this.controller.setExclusiveMode(true);
            }
            if (this.sharedPath != null) {
                this.controller.setProperty("sharedPath", this.sharedPath);
            }
            if (this.portArray != null) {
                this.controller.setCandidatePorts(this.portArray);
            }
            if (this.bindAddress != null) {
                this.controller.setBindAddress(InetAddress.getByName(this.bindAddress));
            }
            this.controller.setBecomeMasterOnTimeout(this.becomeMasterOnTimeout);
            this.setDescriptor("crx.cluster.id", this.controller.getClusterId());
            DataStore ds = this.context.getDataStore();
            if (ds instanceof ClusterDataStore) {
                if (this.sharedPath != null) {
                    String msg = "ClusterDataStore must not be used with a shared path.";
                    throw new RepositoryException(msg);
                }
                ClusterDataStore cds = (ClusterDataStore)ds;
                cds.init(this.controller, clusterNode);
                this.controller.setProperty("sharedNothing", Boolean.toString(true));
            }
        }
        catch (Exception e) {
            if (this.controller != null) {
                this.controller.stop();
                this.controller = null;
            }
            if (clusterNode != null) {
                clusterNode.stop();
            }
            log.error("Unable to create cluster controller {}", (Object)e.getMessage());
            if (e instanceof RepositoryException) {
                throw (RepositoryException)((Object)e);
            }
            throw new RepositoryException((Throwable)e);
        }
        return clusterNode;
    }

    protected void initRepositoryDescriptors() throws RepositoryException {
        super.initRepositoryDescriptors();
        ValueFactory valFactory = ValueFactoryImpl.getInstance();
        Value valTrue = valFactory.createValue(true);
        Value valFalse = valFactory.createValue(false);
        this.setDescriptor("query.xpath.doc.order", valFalse);
        this.setDescriptor("query.jcrpath", valTrue);
        this.setDescriptor("query.jcrscore", valTrue);
    }

    protected Properties getCustomRepositoryDescriptors() throws RepositoryException {
        Properties props = super.getCustomRepositoryDescriptors();
        if (props == null) {
            props = new Properties();
        }
        InputStream in = CRXRepositoryImpl.class.getResourceAsStream(CRX_REPOSITORY_PROPERTIES);
        try {
            props.load(in);
            in.close();
            props.setProperty("crx.repository.systemid", this.determineSystemId());
        }
        catch (IOException e) {
            String msg = "Failed to load repository properties: " + e.toString();
            log.error(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        return props;
    }

    private String determineSystemId() throws IOException {
        String id;
        File dir = this.getHomeDir();
        File file = new File(dir, "system.id");
        if (file.exists()) {
            id = FileUtils.readFileToString((File)file, (String)"UTF-8").trim();
        } else {
            File parent = dir.getAbsoluteFile().getParentFile();
            File old = new File(parent, "system.id");
            id = old.exists() ? FileUtils.readFileToString((File)old, (String)"UTF-8").trim() : UUID.randomUUID().toString();
            FileUtils.writeStringToFile((File)file, (String)id);
            old.delete();
        }
        return id;
    }

    protected synchronized void doShutdown() {
        if (this.modules != null) {
            this.stopModules();
        }
        super.doShutdown();
        if (this.controller != null) {
            for (String id : this.controller.activeSkeletons()) {
                log.warn("Cluster skeleton still registered before stopping: {}", (Object)id);
            }
            this.controller.stop();
        }
        this.shutdownHSQL();
        this.shutdownDerby();
        LowDiskSpaceMonitor.getInstance().unregister(this.emergencyCloser);
    }

    private void shutdownHSQL() {
        try {
            Class<?> clazz = Class.forName("com.day.crx.persistence.NativePersistenceManager");
            Method m = clazz.getMethod("shutdown", new Class[0]);
            m.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (Throwable e) {
            log.warn("NativePersistenceManager shutdown error: " + e);
        }
    }

    private void shutdownDerby() {
        System.setProperty("derby.stream.error.field", ((Object)((Object)this)).getClass().getName() + ".DEV_NULL");
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException e) {
            String msg;
            if (!("XJ015".equals(e.getSQLState()) || (msg = e.getMessage()).contains("No suitable driver") || msg.contains("not registered"))) {
                log.error("Derby shutdown error: " + msg);
            }
        }
        catch (Throwable e) {
            log.error("Derby shutdown error: " + e.getMessage());
        }
    }

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public File getHomeDir() {
        return new File(this.getConfig().getHomeDir());
    }

    public ClusterNode getClusterNode() {
        return this.context.getClusterNode();
    }

    public ClusterController getClusterController() {
        return this.controller;
    }

    protected RepositoryImpl.WorkspaceInfo createWorkspaceInfo(WorkspaceConfig wspConfig) {
        return new CRXWorkspaceInfo(wspConfig);
    }

    public VersionLoader getVersionLoader() {
        return new VersionLoader(){

            public boolean load(Session session, InputStream in) throws RepositoryException, IOException {
                return ((CRXVersionManagerImpl)CRXRepositoryImpl.this.context.getInternalVersionManager()).importVersions((SessionImpl)session, in);
            }
        };
    }

    static {
        DEPRECATED_MODULES = new HashSet<String>(Arrays.asList("com.day.crx.core.util.LicenseModule", "com.day.crx.mount.virtual.VirtualRepositoryModule", "com.day.crx.vlt.AutoInstaller", "com.day.crx.replication.ReplicationManager"));
    }

    protected class CRXWorkspaceInfo
    extends RepositoryImpl.WorkspaceInfo {
        private CRXLockManagerImpl lockMgr;

        public CRXWorkspaceInfo(WorkspaceConfig config) {
            super((RepositoryImpl)CRXRepositoryImpl.this, config);
        }

        protected SearchManager getSearchManager() throws RepositoryException {
            return super.getSearchManager();
        }

        protected LockManagerImpl createLockManager() throws RepositoryException {
            return new CRXLockManagerImpl((SessionImpl)this.getSystemSession(), this.getFileSystem(), this.isSimpleLocking(), CRXRepositoryImpl.this.context.getExecutor());
        }

        private boolean isSimpleLocking() {
            WorkspaceConfig wc = this.getConfig();
            return wc instanceof CRXWorkspaceConfig && ((CRXWorkspaceConfig)wc).isSimpleLocking();
        }

        protected PersistenceManager createPersistenceManager(PersistenceManagerConfig pmConfig, PMContext context) throws RepositoryException {
            try {
                PersistenceManager pm = (PersistenceManager)pmConfig.newInstance(PersistenceManager.class);
                pm.init(context);
                return pm;
            }
            catch (Exception e) {
                String msg = "Cannot instantiate persistence manager " + pmConfig.getClassName();
                throw new RepositoryException(msg, (Throwable)e);
            }
        }

        protected void doInitialize() throws RepositoryException {
            WorkspaceConfig config = this.getConfig();
            FileSystem fs = config.getFileSystem();
            this.setField("fs", fs);
            PMContext context = CRXRepositoryImpl.this.createPMContext(new File(config.getHomeDir()), fs, true);
            PersistenceManager persistMgr = this.createPersistenceManager(config.getPersistenceManagerConfig(), context);
            this.setField("persistMgr", persistMgr);
            this.doVersionRecovery();
            ISMLocking ismLocking = config.getISMLocking();
            try {
                SharedItemStateManager itemStateMgr = CRXRepositoryImpl.this.createItemStateManager(persistMgr, true, ismLocking);
                this.setField("itemStateMgr", itemStateMgr);
                try {
                    itemStateMgr.addVirtualItemStateProvider(CRXRepositoryImpl.this.context.getInternalVersionManager().getVirtualItemStateProvider());
                    itemStateMgr.addVirtualItemStateProvider(CRXRepositoryImpl.this.getVirtualNodeTypeStateManager().getVirtualItemStateProvider());
                }
                catch (Exception e) {
                    log.error("Unable to add vmgr: " + e.toString(), (Throwable)e);
                }
                ClusterNode clusterNode = CRXRepositoryImpl.this.context.getClusterNode();
                if (clusterNode != null && config.isClustered()) {
                    UpdateEventChannel updateChannel = clusterNode.createUpdateChannel(this.getName());
                    this.setField("updateChannel", updateChannel);
                    itemStateMgr.setEventChannel(updateChannel);
                    updateChannel.setListener((UpdateEventListener)this);
                }
            }
            catch (ItemStateException ise) {
                String msg = "failed to instantiate shared item state manager";
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)ise);
            }
            ObservationDispatcher dispatcher = new ObservationDispatcher();
            this.setField("dispatcher", dispatcher);
            CRXRepositoryImpl.this.getDelegatingDispatcher().addDispatcher(dispatcher);
        }

        private void setField(String name, Object value) throws RepositoryException {
            try {
                Field f = RepositoryImpl.WorkspaceInfo.class.getDeclaredField(name);
                f.setAccessible(true);
                f.set((Object)this, value);
            }
            catch (Exception e) {
                String msg = "Unable to set 'persistMgr' field.";
                throw new RepositoryException(msg, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doDispose() {
            if (this.lockMgr != null) {
                this.lockMgr.close();
                this.lockMgr = null;
            }
            if (CRXRepositoryImpl.this.systemSessions != null) {
                HashMap hashMap = CRXRepositoryImpl.this.systemSessions;
                synchronized (hashMap) {
                    CRXSystemSession sess = (CRXSystemSession)((Object)CRXRepositoryImpl.this.systemSessions.remove(this.getName()));
                    if (sess != null) {
                        sess.logout();
                    }
                }
            }
            super.doDispose();
        }
    }
}

