/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core;

import com.day.crx.core.CRXRepositoryImpl;
import com.day.crx.core.config.CRXRepositoryConfig;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.TransientRepository;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRXRepositoryFactory
implements RepositoryFactory {
    private static final Map<Properties, TransientRepository> REPOSITORIES = new HashMap<Properties, TransientRepository>();

    public Repository getRepository(Map parameters) throws RepositoryException {
        if (parameters != null && parameters.containsKey("org.apache.jackrabbit.repository.uri")) {
            Object parameter = parameters.get("org.apache.jackrabbit.repository.uri");
            try {
                URI uri = new URI(parameter.toString().trim());
                if ("jcr-crx".equalsIgnoreCase(uri.getScheme()) && uri.getAuthority() == null) {
                    File file = new File(uri.getPath());
                    if (file.isFile()) {
                        return null;
                    }
                    return this.getRepository(file.getPath(), parameters);
                }
                return null;
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    private Repository getRepository(String home, Map<?, ?> parameters) throws RepositoryException {
        return CRXRepositoryFactory.getOrCreateRepository(home, parameters);
    }

    private static synchronized TransientRepository getOrCreateRepository(String home, Map<?, ?> parameters) throws RepositoryException {
        TransientRepository repository;
        final Properties properties = new Properties(System.getProperties());
        for (Map.Entry<?, ?> entry : parameters.entrySet()) {
            Object key = entry.getKey();
            if (key == null) continue;
            Object value = entry.getValue();
            if (value != null) {
                properties.setProperty(key.toString(), value.toString());
                continue;
            }
            properties.remove(key.toString());
        }
        if (home != null) {
            properties.put("rep.home", home);
        }
        if ((repository = REPOSITORIES.get(properties)) == null) {
            repository = new TransientRepository(new TransientRepository.RepositoryFactory(){

                public RepositoryImpl getRepository() throws RepositoryException {
                    try {
                        return CRXRepositoryImpl.create(CRXRepositoryConfig.create(properties));
                    }
                    catch (IOException e) {
                        throw new RepositoryException("Automatic repository configuration failed: " + properties, (Throwable)e);
                    }
                    catch (ConfigurationException e) {
                        throw new RepositoryException("Invalid repository configuration: " + properties, (Throwable)e);
                    }
                }
            }, RepositoryConfig.getRepositoryHome((Properties)properties).getAbsolutePath());
            REPOSITORIES.put(properties, repository);
        }
        return repository;
    }
}

