/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.fs.FileSystem;

public class CRXNamespaceRegistryImpl
extends NamespaceRegistryImpl {
    private static final Map<String, String> RESERVED = new HashMap<String, String>();

    CRXNamespaceRegistryImpl(FileSystem nsRegStore) throws RepositoryException {
        super(nsRegStore);
        for (String prefix : RESERVED.keySet()) {
            try {
                super.getURI(prefix);
            }
            catch (NamespaceException e) {
                super.registerNamespace(prefix, RESERVED.get(prefix));
            }
        }
    }

    public void registerNamespace(String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        if (RESERVED.containsValue(uri)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": reserved URI");
        }
        if (RESERVED.containsKey(prefix)) {
            throw new NamespaceException("failed to register namespace " + prefix + " -> " + uri + ": reserved prefix");
        }
        super.registerNamespace(prefix, uri);
    }

    public void unregisterNamespace(String prefix) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        if (RESERVED.containsKey(prefix)) {
            throw new NamespaceException("reserved prefix: " + prefix);
        }
        super.unregisterNamespace(prefix);
    }

    static {
        RESERVED.put("crx", "http://www.day.com/crx/1.0");
    }
}

