/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core;

import com.day.crx.core.ntlm.NTLMCredentials;
import com.day.crx.core.ntlm.NTLMCredentialsAuthentication;
import java.security.Principal;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.core.security.authentication.Authentication;
import org.apache.jackrabbit.core.security.authentication.DefaultLoginModule;

public class CRXLoginModule
extends DefaultLoginModule {
    private static final String PARAM_DISABLE_NTLM_AUTH = "disableNTLMAuth";
    private boolean disableNTLMAuth;

    protected boolean supportsCredentials(Credentials creds) {
        if (!this.disableNTLMAuth && creds instanceof NTLMCredentials) {
            return true;
        }
        return super.supportsCredentials(creds);
    }

    protected String getUserID(Credentials credentials) {
        if (!this.disableNTLMAuth && credentials instanceof NTLMCredentials) {
            return ((NTLMCredentials)credentials).getAccountName();
        }
        return super.getUserID(credentials);
    }

    protected void doInit(CallbackHandler callbackHandler, Session session, Map map) throws LoginException {
        super.doInit(callbackHandler, session, map);
        if (map.containsKey(PARAM_DISABLE_NTLM_AUTH)) {
            this.disableNTLMAuth = Boolean.parseBoolean(map.get(PARAM_DISABLE_NTLM_AUTH).toString());
        }
    }

    protected Authentication getAuthentication(Principal principal, Credentials creds) throws RepositoryException {
        if (!this.disableNTLMAuth && creds instanceof NTLMCredentials) {
            return new NTLMCredentialsAuthentication(this.user);
        }
        return super.getAuthentication(principal, creds);
    }

    public boolean isDisableNTLMAuth() {
        return this.disableNTLMAuth;
    }

    public void setDisableNTLMAuth(boolean disableNTLMAuth) {
        this.disableNTLMAuth = disableNTLMAuth;
    }
}

