/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster.http;

import com.day.crx.cluster.NullAwareDataInput;
import com.day.crx.cluster.NullAwareDataOutput;
import com.day.crx.cluster.ObjectId;
import com.day.crx.cluster.Request;
import com.day.crx.cluster.TransportHandlerContext;
import com.day.crx.cluster.http.HttpConnection;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestImpl
extends NullAwareDataOutput
implements Request {
    private static Logger log = LoggerFactory.getLogger(RequestImpl.class);
    private static final int DEFAULT_RETRIES = 3;
    private final TransportHandlerContext context;
    private HttpConnection connection;
    private final String operation;
    private final ObjectId objectId;
    private ByteArrayOutputStream requestOut;
    private DataInput responseIn;
    private int retries;
    private boolean prefixWritten;

    public RequestImpl(TransportHandlerContext context, HttpConnection connection, ObjectId objectId, String operation) {
        this.context = context;
        this.connection = connection;
        this.objectId = objectId;
        this.operation = operation;
        this.retries = 3;
        this.requestOut = new ByteArrayOutputStream(256);
        this.setOut(new DataOutputStream(this.requestOut));
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void invoke() throws IOException {
        this.checkPrefixWritten();
        IOException last = null;
        for (int i = 0; i < this.retries; ++i) {
            if (i > 0) {
                String msg = "Connection dropped while executing " + this.getDisplayName() + ", exception: " + last + " reconnecting...";
                log.warn(msg);
                if (log.isDebugEnabled()) {
                    log.debug(msg, (Throwable)last);
                }
                log.info(msg);
                this.reconnect();
            }
            try {
                this.responseIn = this.connection.transmit(this.requestOut.toByteArray());
                return;
            }
            catch (SocketTimeoutException e) {
                last = e;
                continue;
            }
            catch (SocketException e) {
                last = e;
                continue;
            }
            catch (EOFException e) {
                last = e;
            }
        }
        throw last;
    }

    public String getDisplayName() {
        return this.objectId.getInstanceId() + "." + this.operation;
    }

    private void reconnect() throws IOException {
        this.connection.close();
        this.connection = (HttpConnection)this.context.reconnect();
    }

    public DataInput getResponse() throws IOException {
        this.invoke();
        return new NullAwareDataInput(this.responseIn);
    }

    public void write(int b) throws IOException {
        this.checkPrefixWritten();
        super.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.checkPrefixWritten();
        super.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkPrefixWritten();
        super.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.checkPrefixWritten();
        super.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.checkPrefixWritten();
        super.writeByte(v);
    }

    public void writeBytes(String s) throws IOException {
        this.checkPrefixWritten();
        super.writeBytes(s);
    }

    public void writeChar(int v) throws IOException {
        this.checkPrefixWritten();
        super.writeChar(v);
    }

    public void writeChars(String s) throws IOException {
        this.checkPrefixWritten();
        super.writeChars(s);
    }

    public void writeDouble(double v) throws IOException {
        this.checkPrefixWritten();
        super.writeDouble(v);
    }

    public void writeFloat(float v) throws IOException {
        this.checkPrefixWritten();
        super.writeFloat(v);
    }

    public void writeInt(int v) throws IOException {
        this.checkPrefixWritten();
        super.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.checkPrefixWritten();
        super.writeLong(v);
    }

    public void writeShort(int v) throws IOException {
        this.checkPrefixWritten();
        super.writeShort(v);
    }

    public void writeUTF(String str) throws IOException {
        this.checkPrefixWritten();
        super.writeUTF(str);
    }

    private void checkPrefixWritten() throws IOException {
        if (!this.prefixWritten) {
            this.writeNonNullString(this.objectId.toString());
            this.writeNonNullString(this.operation);
            this.prefixWritten = true;
        }
    }
}

