/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster.http;

import com.day.crx.cluster.http.HttpTransportHandler;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.Adler32;

class ParseOptimizer {
    private int length;
    private long checksum;

    ParseOptimizer() {
    }

    public boolean canOptimize() {
        return this.checksum != 0L;
    }

    public boolean matches(PushbackInputStream in) throws IOException {
        byte[] b = new byte[this.length];
        HttpTransportHandler.readFully(in, b);
        Adler32 adler = new Adler32();
        adler.update(b);
        if (adler.getValue() == this.checksum) {
            return true;
        }
        in.unread(b);
        return false;
    }

    public InputStream start(InputStream in) {
        return new DigestInputStream(in);
    }

    public void stop(InputStream in) {
        DigestInputStream cin = (DigestInputStream)in;
        this.length = cin.getLength();
        this.checksum = cin.getChecksum();
    }

    public int getLength() {
        return this.length;
    }

    static class DigestInputStream
    extends FilterInputStream {
        private int length;
        private final Adler32 adler = new Adler32();

        public DigestInputStream(InputStream in) {
            super(in);
        }

        public int read() throws IOException {
            int b = super.read();
            if (b >= 0) {
                ++this.length;
                this.adler.update(b);
            }
            return b;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int read = super.read(b, off, len);
            if (read > 0) {
                this.length += read;
                this.adler.update(b, off, len);
            }
            return read;
        }

        public int getLength() {
            return this.length;
        }

        public long getChecksum() {
            return this.adler.getValue();
        }
    }
}

