/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster.http;

import com.day.crx.cluster.http.HttpEntity;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class HttpResponse
extends HttpEntity {
    private int statusCode;

    public HttpResponse() {
        super(false);
    }

    public HttpResponse(int statusCode) {
        super(true);
        this.statusCode = statusCode;
    }

    public HttpResponse(int statusCode, String msg) throws IOException {
        this(statusCode);
        this.setHeader("Content-Type", "text/plain");
        this.setHeader("Connection", "Close");
        this.writeBytes(msg);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public DataInput read(InputStream in) throws IOException {
        DataInput input = super.read(in);
        if (this.getStatusCode() != 200) {
            String msg = "Server returned status code: " + this.getStatusCode() + ", message: " + input.readLine();
            throw new IOException(msg);
        }
        return input;
    }

    protected void setFirstLine(String s) throws IOException {
        if (s == null) {
            String msg = "Empty answer.";
            throw new EOFException(msg);
        }
        String[] elems = s.split(" ");
        if (elems.length < 2) {
            String msg = "Bad answer: " + s;
            throw new IOException(msg);
        }
        try {
            this.statusCode = Integer.parseInt(elems[1]);
        }
        catch (RuntimeException e) {
            String msg = "Bad answer: " + s;
            throw new IOException(msg);
        }
    }

    protected String getFirstLine() {
        return "HTTP/1.0 " + this.statusCode + " " + this.statusCode + "\r\n";
    }
}

