/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster.http;

import com.day.crx.cluster.InvokeHandler;
import com.day.crx.cluster.NullAwareDataInput;
import com.day.crx.cluster.NullAwareDataOutput;
import com.day.crx.cluster.ObjectId;
import com.day.crx.cluster.ResponseHandler;
import com.day.crx.cluster.TransportHandlerContext;
import com.day.crx.cluster.http.HttpRequest;
import com.day.crx.cluster.http.HttpResponse;
import com.day.crx.cluster.http.HttpTransport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

class HttpProcessor
implements ResponseHandler,
HttpTransport {
    private TransportHandlerContext context;
    private final InputStream socketIn;
    private final OutputStream socketOut;
    private final HttpRequest request = new HttpRequest();
    private final HttpResponse response;
    private boolean replySent;
    private ByteArrayOutputStream bos;

    public HttpProcessor(TransportHandlerContext context, InputStream in, OutputStream out) {
        this.context = context;
        this.socketIn = new BufferedInputStream(in);
        this.socketOut = new BufferedOutputStream(out);
        this.response = new HttpResponse(200);
        this.response.setHeader("Content-Type", "application/octet-stream");
        this.response.setHeader("Connection", "Keep-Alive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterLoop() throws IOException {
        try {
            while (true) {
                DataInput in = this.request.read(this.socketIn);
                if (!this.request.getMethod().equals("POST")) break;
                if (this.request.isChunked() && !this.response.isChunked()) {
                    this.response.setHeader("Transfer-Encoding", "chunked");
                }
                this.handle(in);
            }
            this.sendError(405);
            Object var3_2 = null;
            this.context.disconnected();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.context.disconnected();
            throw throwable;
        }
    }

    private void handle(DataInput in) throws IOException {
        ObjectId objectId = ObjectId.valueOf(in.readUTF());
        InvokeHandler handler = this.context.getInvokeHandler(objectId);
        if (handler == null) {
            String msg = "No invoke handler available for object id: " + objectId;
            throw new IOException(msg);
        }
        String operation = in.readUTF();
        this.response.resetBody();
        this.replySent = false;
        this.bos = null;
        handler.invoke(operation, new NullAwareDataInput(in), this);
        if (!this.replySent) {
            byte[] data = this.bos != null ? this.bos.toByteArray() : new byte[]{};
            this.response.writeInt(data.length);
            this.response.write(data);
        }
        this.response.write(this.socketOut);
        this.socketOut.flush();
    }

    private void sendError(int statusCode) throws IOException {
        HttpResponse response = new HttpResponse(statusCode);
        response.write(this.socketOut);
        this.socketOut.flush();
    }

    public void createExceptionReply(Throwable t) throws IOException {
        this.response.writeInt(-1);
        this.replySent = true;
        HttpProcessor.writeThrowable(t, this.response);
    }

    public DataOutput createReply() throws IOException {
        this.bos = new ByteArrayOutputStream(256);
        return new NullAwareDataOutput(new DataOutputStream(this.bos));
    }

    private static void writeThrowable(Throwable t, DataOutput out) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream ois = new ObjectOutputStream(bout);
        ois.writeObject(t);
        ois.close();
        byte[] data = bout.toByteArray();
        out.writeInt(data.length);
        out.write(data);
    }
}

