/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster.http;

import com.day.crx.cluster.http.ChunkedInputStream;
import com.day.crx.cluster.http.ChunkedOutputStream;
import com.day.crx.cluster.http.HttpTransport;
import com.day.crx.cluster.http.HttpTransportHandler;
import com.day.crx.cluster.http.ParseOptimizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class HttpEntity
implements DataOutput,
HttpTransport {
    private static Logger log = LoggerFactory.getLogger(HttpEntity.class);
    private int contentLength;
    private ByteArrayOutputStream bos;
    private DataOutputStream dos;
    private ChunkedInputStream chunkedIn;
    private ChunkedOutputStream chunkedOut;
    private final Map<String, String> headers = new HashMap<String, String>();
    private boolean chunked;
    private final ParseOptimizer optimizer = new ParseOptimizer();

    public HttpEntity(boolean outgoing) {
        if (outgoing) {
            this.bos = new ByteArrayOutputStream(512);
            this.dos = new DataOutputStream(this.bos);
        }
    }

    public DataInput read(InputStream in) throws IOException {
        if (this.chunkedIn == null) {
            in = this.readHeaders(in);
            if (this.chunked) {
                this.chunkedIn = new ChunkedInputStream(in);
            }
        }
        if (this.chunkedIn != null) {
            return new DataInputStream(this.chunkedIn);
        }
        byte[] body = new byte[]{};
        if (this.contentLength > 0) {
            body = new byte[this.contentLength];
            HttpTransportHandler.readFully(in, body);
        }
        return new DataInputStream(new ByteArrayInputStream(body));
    }

    private InputStream readHeaders(InputStream in) throws IOException {
        String line;
        if (this.optimizer.canOptimize()) {
            PushbackInputStream pin = new PushbackInputStream(in, this.optimizer.getLength());
            if (this.optimizer.matches(pin)) {
                return pin;
            }
            in = pin;
        }
        this.headers.clear();
        this.contentLength = 0;
        this.chunked = false;
        in = this.optimizer.start(in);
        DataInputStream dis = new DataInputStream(in);
        this.setFirstLine(dis.readLine());
        while ((line = dis.readLine()) != null && line.length() != 0) {
            String[] elems = line.split(":");
            if (elems.length != 2) continue;
            this.addHeader(elems[0].trim(), elems[1].trim());
        }
        this.optimizer.stop(in);
        return in;
    }

    protected abstract void setFirstLine(String var1) throws IOException;

    private void addHeader(String name, String value) {
        if (name.equalsIgnoreCase("Transfer-Encoding")) {
            this.chunked = value.equalsIgnoreCase("chunked");
        } else if (name.equalsIgnoreCase("Content-Length")) {
            try {
                this.contentLength = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                String msg = "Bad content length: " + value;
                log.warn(msg);
            }
        }
        this.headers.put(name.toLowerCase(), value);
    }

    public String getHeader(String name) {
        return this.headers.get(name.toLowerCase());
    }

    public void setHeader(String name, String value) {
        if (name.equalsIgnoreCase("Transfer-Encoding")) {
            this.chunked = value.equalsIgnoreCase("chunked");
        }
        this.headers.put(name, value);
    }

    public void resetBody() {
        this.bos.reset();
    }

    public byte[] getBody() {
        return this.bos.toByteArray();
    }

    public boolean isBodyEmpty() {
        return this.bos.size() == 0;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void write(OutputStream out) throws IOException {
        byte[] body = this.bos.toByteArray();
        if (this.chunkedOut == null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(512);
            bos.write(this.getFirstLine().getBytes());
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                bos.write((entry.getKey() + ": " + entry.getValue() + "\r\n").getBytes());
            }
            if (!this.chunked) {
                bos.write(("Content-Length: " + body.length + "\r\n").getBytes());
            }
            bos.write("\r\n".getBytes());
            out.write(bos.toByteArray());
        }
        if (this.chunked) {
            if (this.chunkedOut == null) {
                this.chunkedOut = new ChunkedOutputStream(out);
            }
            this.chunkedOut.write(body);
            this.chunkedOut.flush();
        } else {
            out.write(body);
        }
    }

    protected abstract String getFirstLine();

    public void write(int b) throws IOException {
        this.dos.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.dos.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.dos.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.dos.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.dos.writeByte(v);
    }

    public void writeBytes(String s) throws IOException {
        this.dos.writeBytes(s);
    }

    public void writeChar(int v) throws IOException {
        this.dos.writeChar(v);
    }

    public void writeChars(String s) throws IOException {
        this.dos.writeChars(s);
    }

    public void writeDouble(double v) throws IOException {
        this.dos.writeDouble(v);
    }

    public void writeFloat(float v) throws IOException {
        this.dos.writeFloat(v);
    }

    public void writeInt(int v) throws IOException {
        this.dos.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.dos.writeLong(v);
    }

    public void writeShort(int v) throws IOException {
        this.dos.writeShort(v);
    }

    public void writeUTF(String str) throws IOException {
        this.dos.writeUTF(str);
    }
}

