/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster.http;

import com.day.crx.cluster.Connection;
import com.day.crx.cluster.ObjectId;
import com.day.crx.cluster.Request;
import com.day.crx.cluster.TransportHandlerContext;
import com.day.crx.cluster.http.HttpRequest;
import com.day.crx.cluster.http.HttpResponse;
import com.day.crx.cluster.http.HttpTransport;
import com.day.crx.cluster.http.RequestImpl;
import com.day.crx.persistence.tar.TarUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.commons.io.IOUtils;

class HttpConnection
implements Connection,
HttpTransport {
    private final TransportHandlerContext context;
    private Socket socket;
    private InputStream socketIn;
    private OutputStream socketOut;
    private final HttpRequest request;
    private final HttpResponse response = new HttpResponse();
    private boolean closed;

    HttpConnection(TransportHandlerContext context, Socket socket) throws IOException {
        this.context = context;
        this.socket = socket;
        this.socketIn = new BufferedInputStream(socket.getInputStream());
        this.socketOut = new BufferedOutputStream(socket.getOutputStream());
        this.request = new HttpRequest("POST");
        this.request.setHeader("Content-Type", "application/octet-stream");
        this.request.setHeader("Transfer-Encoding", "chunked");
        this.request.setHeader("Connection", "Keep-Alive");
    }

    public synchronized DataInput transmit(byte[] args) throws IOException {
        this.request.resetBody();
        this.request.write(args);
        this.request.write(this.socketOut);
        this.socketOut.flush();
        DataInput body = this.response.read(this.socketIn);
        if (this.response.getStatusCode() != 200) {
            String msg = "Server returned status code: " + this.response.getStatusCode() + ", message: " + body.readLine();
            throw new IOException(msg);
        }
        int result = body.readInt();
        if (result == -1) {
            IOException e = new IOException("Remote call failed.");
            e.initCause(HttpConnection.readThrowable(body));
            throw e;
        }
        byte[] data = new byte[result];
        body.readFully(data);
        return new DataInputStream(new ByteArrayInputStream(data));
    }

    public synchronized String getRemoteAddress() {
        if (!this.closed) {
            return this.socket.getRemoteSocketAddress().toString();
        }
        return null;
    }

    public Request createRequest(ObjectId objectId, String operation) {
        return new RequestImpl(this.context, this, objectId, operation);
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void close() {
        if (!this.closed) {
            IOUtils.closeQuietly((InputStream)this.socketIn);
            this.socketIn = null;
            IOUtils.closeQuietly((OutputStream)this.socketOut);
            this.socketOut = null;
            this.socket = TarUtils.closeSilently(this.socket);
            this.closed = true;
        }
    }

    private static Throwable readThrowable(DataInput in) throws IOException {
        byte[] data = new byte[in.readInt()];
        in.readFully(data);
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
            return (Throwable)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            String msg = "Unable to find class: " + e.getMessage();
            IOException e2 = new IOException(msg);
            e2.initCause(e);
            throw e2;
        }
    }
}

