/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster.http;

public class Hexdump {
    public static void dump(String prefix, int address, int b) {
        Hexdump.dump(prefix, address, new byte[]{(byte)b}, 0, 1);
    }

    public static void dump(String prefix, int address, byte[] b, int off, int len) {
        int end = off + len;
        while (off < end) {
            int i;
            if (prefix != null) {
                Hexdump.print(prefix);
            }
            Hexdump.print(address);
            Hexdump.print("  ");
            int skiplen = address % 16;
            int linelen = Math.min(end - off, 16 - skiplen);
            for (i = 0; i < skiplen; ++i) {
                Hexdump.print("   ");
            }
            for (i = 0; i < linelen; ++i) {
                Hexdump.print(b[off + i]);
                Hexdump.print(" ");
            }
            for (i = linelen; i < 16 - skiplen; ++i) {
                Hexdump.print("   ");
            }
            Hexdump.print("  ");
            for (i = 0; i < skiplen; ++i) {
                Hexdump.print(" ");
            }
            for (i = 0; i < linelen; ++i) {
                Hexdump.print((char)b[off + i]);
            }
            Hexdump.print("\n");
            off += linelen;
            address += linelen;
        }
    }

    private static void print(int n) {
        String s = Integer.toHexString(n);
        if (s.length() < 8) {
            Hexdump.print("00000000".substring(s.length()));
        }
        Hexdump.print(s);
    }

    private static void print(byte b) {
        String s = Integer.toHexString(b & 0xFF);
        if (s.length() < 2) {
            Hexdump.print("00".substring(2 - s.length()));
        }
        Hexdump.print(s);
    }

    private static void print(char c) {
        if (c >= ' ' && c <= '\u007f') {
            Hexdump.print("" + c);
        } else {
            Hexdump.print(".");
        }
    }

    private static void print(String s) {
        System.out.print(s);
    }
}

