/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster;

import com.day.crx.cluster.MasterInfo;
import com.day.crx.cluster.ObjectStub;
import com.day.crx.cluster.Request;
import com.day.crx.cluster.SlaveInfo;
import com.day.crx.cluster.SlaveInfoStub;
import java.io.DataInput;
import java.io.IOException;

public class MasterInfoStub
extends ObjectStub
implements MasterInfo {
    public String getOS() {
        Request request = this.createRequest("getOS");
        try {
            return request.getResponse().readUTF();
        }
        catch (IOException e) {
            this.log(request.getDisplayName(), e);
            return null;
        }
    }

    public String getIdentity() {
        Request request = this.createRequest("getIdentity");
        try {
            return request.getResponse().readUTF();
        }
        catch (IOException e) {
            this.log(request.getDisplayName(), e);
            return null;
        }
    }

    public String getProperty(String key) {
        Request request = this.createRequest("getProperty");
        try {
            request.writeUTF(key);
            return request.getResponse().readUTF();
        }
        catch (IOException e) {
            this.log(request.getDisplayName(), e);
            return null;
        }
    }

    public SlaveInfo[] getSlaveInfos() {
        Request request = this.createRequest("getSlaveInfos");
        try {
            DataInput response = request.getResponse();
            SlaveInfo[] slaves = new SlaveInfoStub[response.readInt()];
            for (int i = 0; i < slaves.length; ++i) {
                String identity = response.readUTF();
                String os = response.readUTF();
                boolean isLocal = response.readBoolean();
                slaves[i] = new SlaveInfoStub(identity, os, isLocal);
                ((ObjectStub)((Object)slaves[i])).init(this.getConnection(), this.getObjectId());
            }
            return slaves;
        }
        catch (IOException e) {
            this.log(request.getDisplayName(), e);
            return new SlaveInfo[0];
        }
    }

    public String getControlFolder() {
        Request request = this.createRequest("getControlFolder");
        try {
            return request.getResponse().readUTF();
        }
        catch (IOException e) {
            this.log(request.getDisplayName(), e);
            return null;
        }
    }
}

