/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster;

import com.day.crx.cluster.InvokeHandler;
import com.day.crx.cluster.MasterInfo;
import com.day.crx.cluster.ResponseHandler;
import com.day.crx.cluster.SlaveInfo;
import com.day.crx.cluster.TypeId;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;

abstract class MasterInfoImplBase
extends InvokeHandler
implements MasterInfo {
    private static final HashMap<String, Integer> OPERATIONS = new HashMap();

    protected MasterInfoImplBase() {
        super(MasterInfo.OBJECT_ID);
    }

    protected void doInvoke(String operation, DataInput in, ResponseHandler handler) throws IOException {
        switch (OPERATIONS.get(operation)) {
            case 0: {
                handler.createReply().writeUTF(this.getOS());
                break;
            }
            case 1: {
                handler.createReply().writeUTF(this.getIdentity());
                break;
            }
            case 2: {
                SlaveInfo[] slaves = this.getSlaveInfos();
                DataOutput reply = handler.createReply();
                reply.writeInt(slaves.length);
                for (int i = 0; i < slaves.length; ++i) {
                    SlaveInfo slave = slaves[i];
                    reply.writeUTF(slave.getIdentity());
                    reply.writeUTF(slave.getOS());
                    reply.writeBoolean(slave.isLocal());
                }
                break;
            }
            case 3: {
                handler.createReply().writeUTF(this.getProperty(in.readUTF()));
                break;
            }
            case 4: {
                String identity = in.readUTF();
                String key = in.readUTF();
                handler.createReply().writeUTF(this.getProperty(identity, key));
                break;
            }
            case 5: {
                handler.createReply().writeUTF(this.getControlFolder());
            }
        }
    }

    protected TypeId getTypeId() {
        return MasterInfoImplBase.toTypeId(MasterInfo.class);
    }

    protected abstract String getProperty(String var1, String var2) throws IOException;

    static {
        OPERATIONS.put("getOS", new Integer(0));
        OPERATIONS.put("getIdentity", new Integer(1));
        OPERATIONS.put("getSlaveInfos", new Integer(2));
        OPERATIONS.put("getProperty", new Integer(3));
        OPERATIONS.put("getSlaveProperty", new Integer(4));
        OPERATIONS.put("getControlFolder", new Integer(5));
    }
}

