/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster;

import com.day.crx.cluster.ClusterController;
import com.day.crx.cluster.ObjectId;
import com.day.crx.cluster.ObjectStub;
import com.day.crx.cluster.ResponseHandler;
import com.day.crx.cluster.TypeId;
import java.io.DataInput;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InvokeHandler {
    private static Logger log = LoggerFactory.getLogger(InvokeHandler.class);
    private ClusterController controller;
    private boolean activated;
    private ObjectId objectId;

    protected InvokeHandler(String instanceId) {
        this.objectId = new ObjectId(this.getTypeId(), instanceId);
    }

    protected InvokeHandler(ObjectId objectId) {
        this.objectId = objectId;
    }

    public void activate(ClusterController controller) throws IOException {
        if (!this.activated) {
            this.controller = controller;
            this.doActivate();
            this.activated = true;
        }
    }

    protected void doActivate() throws IOException {
    }

    public ObjectStub createStub() throws IOException {
        String impl = this.getTypeId().getId() + "Stub";
        try {
            return (ObjectStub)Class.forName(impl).newInstance();
        }
        catch (InstantiationException e) {
            String msg = "Unable to instantiate " + impl;
            IOException e2 = new IOException(msg);
            e2.initCause(e);
            throw e2;
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal to access " + impl;
            IOException e2 = new IOException(msg);
            e2.initCause(e);
            throw e2;
        }
        catch (ClassNotFoundException e) {
            String msg = "Class not found " + impl;
            IOException e2 = new IOException(msg);
            e2.initCause(e);
            throw e2;
        }
    }

    public final void invoke(String operation, DataInput in, ResponseHandler handler) throws IOException {
        try {
            this.doInvoke(operation, in, handler);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            handler.createExceptionReply(e);
        }
    }

    protected abstract void doInvoke(String var1, DataInput var2, ResponseHandler var3) throws IOException;

    public void deactivate() {
        if (this.activated) {
            this.controller = null;
            this.doDeactivate();
            this.activated = false;
        }
    }

    protected void doDeactivate() {
    }

    public void exitOperation(String name) {
        if (this.controller == null || this.controller.masterOvertaken()) {
            String msg = "Master changed while executing operation: " + name;
            log.warn(msg);
        }
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public String getCallerIdentity() {
        String identity = null;
        if (this.controller != null && (identity = this.controller.getRemoteIdentity()) == null) {
            identity = this.controller.getIdentity();
        }
        return identity;
    }

    public ClusterController getController() {
        return this.controller;
    }

    public boolean isDaemon() {
        return false;
    }

    protected TypeId getTypeId() {
        return InvokeHandler.toTypeId("com.day.crx.cluster.Object");
    }

    public static TypeId toTypeId(Class<?> c) {
        return new TypeId(c);
    }

    private static TypeId toTypeId(String name) {
        return new TypeId(name);
    }
}

