/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster;

import com.day.crx.cluster.AbstractMasterElection;
import com.day.crx.cluster.TransportHandler;
import com.day.crx.cluster.TransportHandlerContext;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileBasedElection
extends AbstractMasterElection {
    private static Logger log = LoggerFactory.getLogger(FileBasedElection.class);
    private static final int MAX_RETRIES = 3;
    private static final long RETRY_TIME = 60000L;
    private static final long REWRITE_DELAY = 1000L;
    private static final int SLOT_TIMEOUT_MS = 1000;
    private long timestamp;
    private long masterStartTime;
    private int masterTakeovers;
    private boolean ignoreOthers;

    public FileBasedElection(String controlPath, String identity, String host, int port, int[] candidatePorts, TransportHandler handler, TransportHandlerContext context) throws IOException {
        super(controlPath, identity, host, port, candidatePorts, handler, context);
    }

    public void setIgnoreOthers(boolean ignoreOthers) {
        this.ignoreOthers = ignoreOthers;
    }

    protected void doElect(boolean becomeMaster) throws IOException {
        if (this.masterTakeovers >= 3) {
            String msg = "Too many consecutive master take overs.";
            throw new IOException(msg);
        }
        int timeoutSlot = 1000;
        for (int i = 0; i < 3; ++i) {
            long timeout = (long)(Math.random() * (double)timeoutSlot);
            if (this.doElect(timeout, becomeMaster)) {
                return;
            }
            timeoutSlot <<= 1;
        }
        String msg = "Unable to perform election.";
        throw new IOException(msg);
    }

    private boolean doElect(long timeout, boolean becomeMaster) throws IOException {
        String checkKey;
        Properties prop;
        if (!becomeMaster && !this.ignoreOthers && (prop = this.readControlFile()) != null) {
            this.listenerAddress = prop.getProperty("address");
            this.checkKey = prop.getProperty("check");
            if (this.tryConnect()) {
                log.info("Connected to: " + this.listenerAddress);
                this.isMaster = false;
                return true;
            }
        }
        this.createListener();
        File tmpFile = File.createTempFile("icp", "tmp", this.controlFolder);
        for (int i = 0; i < 3; ++i) {
            this.saveListenerAddress(tmpFile);
            if (tmpFile.lastModified() > this.controlFile.lastModified()) break;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        long lastModified = this.controlFile.lastModified();
        if (tmpFile.lastModified() <= this.controlFile.lastModified()) {
            String msg = "Unable to create file with modification time > " + lastModified;
            throw new IOException(msg);
        }
        this.timestamp = tmpFile.lastModified();
        this.controlFile.delete();
        if (!tmpFile.renameTo(this.controlFile)) {
            tmpFile.delete();
            log.info("Unable to rename " + tmpFile + " to " + this.controlFile);
            return false;
        }
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Properties prop2 = this.readControlFile();
        if (prop2 != null && this.checkKey.equals(checkKey = prop2.getProperty("check"))) {
            this.isMaster = true;
            return true;
        }
        log.info("Information changed in control file.");
        return false;
    }

    public boolean isMaster() throws IOException {
        if (this.isMaster && this.masterOvertaken()) {
            long masterStartTime = this.timestamp;
            this.elect();
            this.controlFileChanged(this.isMaster, masterStartTime);
        }
        return super.isMaster();
    }

    public boolean masterOvertaken() {
        return !this.controlFile.exists() || this.controlFile.lastModified() > this.timestamp;
    }

    private void controlFileChanged(boolean isMaster, long masterStartTime) {
        if (isMaster) {
            if (this.masterStartTime + 60000L <= masterStartTime) {
                ++this.masterTakeovers;
            } else {
                this.masterStartTime = masterStartTime;
                this.masterTakeovers = 0;
            }
        } else {
            this.masterStartTime = 0L;
        }
    }
}

