/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.cluster;

import com.day.crx.cluster.AbstractMasterElection;
import com.day.crx.cluster.Connection;
import com.day.crx.cluster.ElectionListener;
import com.day.crx.cluster.FileBasedElection;
import com.day.crx.cluster.InvokeHandler;
import com.day.crx.cluster.MasterInfo;
import com.day.crx.cluster.MasterInfoImpl;
import com.day.crx.cluster.ObjectId;
import com.day.crx.cluster.ObjectStub;
import com.day.crx.cluster.RepositoryLockElection;
import com.day.crx.cluster.TransportHandler;
import com.day.crx.cluster.TransportHandlerContext;
import com.day.crx.cluster.http.HttpTransportHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterController
implements ElectionListener {
    private static Logger log = LoggerFactory.getLogger(ClusterController.class);
    private static final String PN_PREFIX = "com.day.crx.cluster.ClusterController.";
    private static final String PN_ELECTION = "com.day.crx.cluster.ClusterController.Election";
    private static final String PN_PORT = "com.day.crx.cluster.ClusterController.Port";
    private static final String PN_INFO = "com.day.crx.cluster.ClusterController.Info";
    private static final String DEFAULT_PATH = ".";
    private static final int DEFAULT_LOCK_TIMEOUT = 1000;
    private static final String DEFAULT_IDENTITY = "anonymous";
    private static final String DEFAULT_ELECTION = "file";
    public static final String PN_HOST = "com.day.crx.cluster.ClusterController.Host";
    public static final String PN_PATH = "com.day.crx.cluster.ClusterController.Path";
    public static final String PN_LOCK_TIMEOUT = "com.day.crx.cluster.ClusterController.LockTimeout";
    public static final String PN_IDENTITY = "com.day.crx.cluster.ClusterController.Identity";
    public static final String PN_BIND_ADDRESS = "com.day.crx.cluster.ClusterController.BindAddress";
    public static final String PN_PORT_LIST = "com.day.crx.cluster.ClusterController.PortList";
    public static final String PN_CONNECT_TIMEOUT = "com.day.crx.cluster.ClusterController.ConnectTimeout";
    public static final String PN_SOCKET_TIMEOUT = "com.day.crx.cluster.ClusterController.SocketTimeout";
    public static final String PN_CONTROL = "com.day.crx.cluster.ClusterController.Control";
    private final ThreadLocal<String> callerIdentity = new ThreadLocal();
    private String identity;
    private String info;
    private TransportHandlerContext context;
    private TransportHandler handler;
    private AbstractMasterElection election;
    private boolean closed;
    private final HashMap<ObjectId, InvokeHandler> handlers = new HashMap();
    private final HashMap<ObjectId, ObjectStub> stubs = new HashMap();

    private ClusterController(Properties props) throws IOException {
        if (props == null) {
            props = System.getProperties();
        }
        this.identity = props.getProperty(PN_IDENTITY, DEFAULT_IDENTITY);
        this.info = props.getProperty(PN_INFO);
        if (this.info == null) {
            this.info = ClusterController.getDefaultInfo();
        }
        this.context = new TransportHandlerContext(this);
        this.handler = this.createTransportHandler(props);
        this.handler.init(this.context);
        this.connect(new MasterInfoImpl(this.context));
        this.election = this.createElection(props);
        this.election.addListener(this);
        this.electMaster();
    }

    private TransportHandler createTransportHandler(Properties props) throws IOException {
        return new HttpTransportHandler();
    }

    private AbstractMasterElection createElection(Properties props) throws IOException {
        String controlPath = props.getProperty(PN_CONTROL);
        if (controlPath == null) {
            controlPath = props.getProperty(PN_PATH, DEFAULT_PATH);
            controlPath = controlPath + File.separator + "control";
        }
        int lockTimeout = 1000;
        String s = props.getProperty(PN_LOCK_TIMEOUT);
        if (s != null) {
            try {
                lockTimeout = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String host = props.getProperty(PN_HOST);
        int port = 0;
        s = props.getProperty(PN_PORT);
        if (s != null) {
            try {
                port = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int[] candidatePorts = null;
        String portList = props.getProperty(PN_PORT_LIST);
        if (portList != null) {
            candidatePorts = ClusterController.parsePortList(portList);
        }
        AbstractMasterElection election = null;
        s = props.getProperty(PN_ELECTION, DEFAULT_ELECTION);
        if (s.equalsIgnoreCase(DEFAULT_ELECTION)) {
            election = new FileBasedElection(controlPath, this.identity, host, port, candidatePorts, this.handler, this.context);
        } else if (s.equalsIgnoreCase("lock")) {
            election = new RepositoryLockElection(controlPath, this.identity, host, port, candidatePorts, this.handler, this.context, lockTimeout);
        } else {
            String msg = "Election type unknown: " + s;
            throw new IOException(msg);
        }
        s = props.getProperty(PN_CONNECT_TIMEOUT);
        if (s != null) {
            try {
                election.setConnectTimeout(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((s = props.getProperty(PN_SOCKET_TIMEOUT)) != null) {
            try {
                election.setSocketTimeout(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((s = props.getProperty(PN_BIND_ADDRESS)) != null) {
            election.setBindAddress(InetAddress.getByName(s));
        }
        return election;
    }

    public static ClusterController init(Properties props) throws IOException {
        return new ClusterController(props);
    }

    public static boolean isClusterController(File folder) {
        if (!folder.isDirectory()) {
            return false;
        }
        File controlFolder = new File(folder, "control");
        if (!controlFolder.exists() || !controlFolder.isDirectory()) {
            return false;
        }
        return AbstractMasterElection.isControlFolder(controlFolder);
    }

    public synchronized void run() {
        while (!this.closed) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public synchronized void shutdown() {
        this.checkOpen();
        for (InvokeHandler handler : this.handlers.values()) {
            handler.deactivate();
        }
        this.closed = true;
        this.election.close();
        this.notifyAll();
    }

    String getRemoteIdentity() {
        return this.callerIdentity.get();
    }

    public synchronized void connect(InvokeHandler handler) {
        this.checkOpen();
        ObjectId objectId = handler.getObjectId();
        if (this.handlers.containsKey(objectId)) {
            String msg = "Object already connected: " + this.handlers.get(objectId);
            throw new IllegalArgumentException(msg);
        }
        this.handlers.put(objectId, handler);
    }

    public synchronized void disconnect(InvokeHandler handler) {
        this.checkOpen();
        ObjectId objectId = handler.getObjectId();
        if (this.handlers.remove(objectId) == null) {
            String msg = "No handler for object id: " + objectId;
            log.warn(msg);
        }
        handler.deactivate();
        for (InvokeHandler h : this.handlers.values()) {
            if (h.isDaemon()) continue;
            return;
        }
        this.shutdown();
    }

    public synchronized Object lookup(ObjectId objectId) throws IOException {
        this.checkOpen();
        InvokeHandler handler = this.getHandler(objectId);
        if (handler == null) {
            String msg = "No handler for object id: " + objectId;
            throw new IOException(msg);
        }
        if (this.isMaster()) {
            handler.activate(this);
            return handler;
        }
        ObjectStub stub = this.stubs.get(objectId);
        if (stub == null) {
            stub = handler.createStub();
            stub.init(this.election.getConnection(), objectId);
        }
        return stub;
    }

    public String getIdentity() {
        this.checkOpen();
        return this.identity;
    }

    String getInfo() {
        this.checkOpen();
        return this.info;
    }

    File getControlFolder() {
        return this.election.getControlFolder();
    }

    String getProperty(String key) {
        return this.election.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.election.setProperty(key, value);
    }

    protected File getIdentityFile(String identity) {
        return this.election.getIdentityFile(identity);
    }

    private static String getDefaultInfo() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    public boolean isMaster() throws IOException {
        this.checkOpen();
        return this.election.isMaster();
    }

    public void becomeMaster() throws IOException {
        this.checkOpen();
        if (!this.election.isMaster()) {
            this.election.elect(true);
        }
    }

    public boolean masterOvertaken() {
        return this.election.masterOvertaken();
    }

    public MasterInfo getMasterInfo() throws IOException {
        return (MasterInfo)this.lookup(MasterInfo.OBJECT_ID);
    }

    private void checkOpen() {
        if (this.closed) {
            String msg = "Interconnect closed.";
            throw new IllegalStateException(msg);
        }
    }

    void setCurrentIdentity(String identity) {
        this.callerIdentity.set(identity);
    }

    InvokeHandler getHandler(ObjectId objectId) {
        return this.handlers.get(objectId);
    }

    Connection getConnection() throws IOException {
        return this.election.getConnection();
    }

    boolean checkKey(String key) {
        return this.election.checkKey(key);
    }

    boolean checkIdentity(String identity) {
        return this.election.checkIdentity(identity);
    }

    void electMaster() throws IOException {
        this.election.elect();
    }

    synchronized boolean isAlive() {
        return !this.closed;
    }

    void dump(PrintWriter pw) {
        pw.println("identity: " + this.identity);
        pw.println("handlers: ");
        for (Map.Entry<ObjectId, InvokeHandler> entry : this.handlers.entrySet()) {
            ObjectId objectId = entry.getKey();
            pw.println("    " + objectId.getInstanceId() + ": " + entry.getValue());
        }
    }

    @Override
    public void electionStarted(boolean isMaster) {
        for (InvokeHandler handler : this.handlers.values()) {
            handler.deactivate();
        }
    }

    @Override
    public void electionEnded(boolean isMaster) {
        if (isMaster) {
            for (InvokeHandler handler : this.handlers.values()) {
                try {
                    handler.activate(this);
                }
                catch (IOException e) {
                    String msg = "Unable to activate handler: " + handler;
                    log.warn(msg, (Throwable)e);
                }
            }
        }
    }

    public static int[] parsePortList(String portList) throws NumberFormatException, IllegalArgumentException {
        if (portList == null) {
            portList = "";
        }
        if ((portList = portList.trim()).length() == 0) {
            return new int[]{0};
        }
        ArrayList<Integer> list = ClusterController.parseList(portList);
        int[] array = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    private static ArrayList<Integer> parseList(String list) throws NumberFormatException, IllegalArgumentException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (list.indexOf(44) >= 0) {
            StringTokenizer tokenizer = new StringTokenizer(list, ",");
            if (!tokenizer.hasMoreElements()) {
                throw new IllegalArgumentException(list);
            }
            while (tokenizer.hasMoreElements()) {
                result.addAll(ClusterController.parseList(tokenizer.nextToken()));
            }
            return result;
        }
        int idx = list.indexOf(45);
        if (idx >= 0) {
            int start = Integer.decode(list.substring(0, idx).trim());
            int end = Integer.decode(list.substring(idx + 1).trim());
            if (start < 0 || end < start) {
                throw new IllegalArgumentException(start + " < 0 || " + end + " < " + start + ": " + list);
            }
            for (int i = start; i <= end; ++i) {
                result.add(new Integer(i));
            }
        } else {
            Integer x = Integer.decode(list.trim());
            if (x < 0) {
                throw new IllegalArgumentException(x + " < 0");
            }
            result.add(x);
        }
        return result;
    }

    public static ServerSocket openServerSocket(int[] portArray, InetAddress bindInetAddress) throws IOException {
        IOException lastException = null;
        if (portArray == null || portArray.length == 0) {
            portArray = new int[]{0};
        }
        for (int i = 0; i < portArray.length; ++i) {
            int port = portArray[i];
            try {
                if (bindInetAddress == null) {
                    return new ServerSocket(port);
                }
                return new ServerSocket(port, 0, bindInetAddress);
            }
            catch (IOException e) {
                lastException = e;
                continue;
            }
        }
        throw lastException;
    }
}

