/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.servlets;

import com.day.cq.commons.servlets.AbstractPredicateServlet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public abstract class AbstractSearchServlet
extends AbstractPredicateServlet {
    private static final long serialVersionUID = 6105423525102347224L;
    public static final String QUERY = "query";
    public static final String START = "start";
    public static final String LIMIT = "limit";
    public static final String TIDY = "tidy";
    public static final List<Character.UnicodeBlock> WORD_CHARS;
    public static final String SPLIT_CHARACTERS = " _-.,";

    protected boolean isSingleWord(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (!WORD_CHARS.contains(Character.UnicodeBlock.of(text.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    protected String applyWildcard(String text) {
        if (!this.isSingleWord(text)) {
            return text;
        }
        StringBuffer modified = new StringBuffer();
        StringTokenizer t = new StringTokenizer(text, SPLIT_CHARACTERS);
        String space = "";
        while (t.hasMoreTokens()) {
            modified.append(space);
            space = " ";
            modified.append(t.nextToken());
        }
        modified.append("*");
        return modified.toString();
    }

    static {
        ArrayList<Character.UnicodeBlock> list = new ArrayList<Character.UnicodeBlock>();
        list.add(Character.UnicodeBlock.HIRAGANA);
        list.add(Character.UnicodeBlock.KATAKANA);
        list.add(Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS);
        list.add(Character.UnicodeBlock.BOPOMOFO);
        list.add(Character.UnicodeBlock.CJK_COMPATIBILITY);
        list.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A);
        list.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS);
        list.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS);
        list.add(Character.UnicodeBlock.SPECIALS);
        list.add(Character.UnicodeBlock.HANGUL_SYLLABLES);
        list.add(Character.UnicodeBlock.HANGUL_JAMO);
        WORD_CHARS = Collections.unmodifiableList(list);
    }
}

