/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.jcr;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true, metatype=false)
@Reference(name="repository", referenceInterface=SlingRepository.class, policy=ReferencePolicy.STATIC)
public abstract class AbstractRepositoryService {
    private Session adminSession;
    @Reference(policy=ReferencePolicy.STATIC)
    protected JcrResourceResolverFactory resourceManagerFactory;
    private SlingRepository repository;
    protected Logger logger = LoggerFactory.getLogger(AbstractRepositoryService.class);

    protected final void bindRepository(SlingRepository repo) {
        if (this.adminSession != null) {
            this.closeSession(this.adminSession);
            this.adminSession = null;
        }
        this.repository = repo;
        try {
            this.adminSession = this.createSession(this.repository);
        }
        catch (RepositoryException re) {
            this.logger.error("Cannot get Repository Session", (Throwable)re);
        }
    }

    protected final void unbindRepository(SlingRepository repo) {
        if (this.repository == repo) {
            if (this.adminSession != null) {
                this.closeSession(this.adminSession);
                this.adminSession = null;
            }
            this.repository = null;
        }
    }

    protected Session createSession(SlingRepository repo) throws RepositoryException {
        return repo.loginAdministrative(null);
    }

    protected SlingRepository getRepository() {
        return this.repository;
    }

    protected void closeSession(Session session) {
        session.logout();
    }

    protected Session getAdminSession() {
        return this.adminSession;
    }

    protected ResourceResolver getResourceResolver() throws SlingException {
        if (this.adminSession != null && this.resourceManagerFactory != null) {
            return this.resourceManagerFactory.getResourceResolver(this.adminSession);
        }
        return null;
    }

    protected void bindResourceManagerFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resourceManagerFactory = jcrResourceResolverFactory;
    }

    protected void unbindResourceManagerFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resourceManagerFactory == jcrResourceResolverFactory) {
            this.resourceManagerFactory = null;
        }
    }
}

