/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.impl;

import com.day.cq.commons.thumbnail.ThumbnailProvider;
import com.day.cq.commons.thumbnail.ThumbnailProviderManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Reference(name="ThumbnailProvider", referenceInterface=ThumbnailProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
@Service(value={ThumbnailProviderManager.class})
public class ThumbnailProviderManagerImpl
implements ThumbnailProviderManager {
    private final Logger log = LoggerFactory.getLogger(ThumbnailProviderManagerImpl.class);
    private static String PRED_REF_NAME = "ThumbnailProvider";
    private static String THUMBNAIL_PROVIDER_NAME = "thumbnail.provider.name";
    private ComponentContext osgiComponentContext;
    private List<ServiceReference> delayedRefs;
    private Map<String, ThumbnailProvider> thumbnailProviders = new HashMap<String, ThumbnailProvider>();

    public ThumbnailProvider getThumbnailProvider(Node node) {
        try {
            return this.thumbnailProviders.get(node.getPrimaryNodeType().getName());
        }
        catch (RepositoryException e) {
            this.log.warn("No ThumbnailProvider found");
            this.log.debug("Choosing default thumbnail provider");
            return this.thumbnailProviders.get("*");
        }
    }

    protected void activate(ComponentContext componentContext) {
        this.osgiComponentContext = componentContext;
        if (this.osgiComponentContext != null && this.delayedRefs != null) {
            List<ServiceReference> list = this.delayedRefs;
            this.delayedRefs = null;
            for (ServiceReference ref : list) {
                this.initThumbnailProvider(ref);
            }
        }
        this.log.info("Thumbnail provider manager activated.");
    }

    protected void deactivate(ComponentContext componentContext) {
        this.log.info("Thumbnail provider manager deactivated.");
    }

    protected void bindThumbnailProvider(ServiceReference ref) {
        if (this.osgiComponentContext == null) {
            if (this.delayedRefs == null) {
                this.delayedRefs = new LinkedList<ServiceReference>();
            }
            this.delayedRefs.add(ref);
        } else {
            this.initThumbnailProvider(ref);
        }
    }

    protected void unbindThumbnailProvider(ServiceReference ref) {
        String name = (String)ref.getProperty(THUMBNAIL_PROVIDER_NAME);
        if (this.thumbnailProviders.remove(name) == null) {
            this.log.warn("removing unregistered thumbnail provider {}", (Object)name);
        } else {
            this.log.info("unregistering thumbnail provider {}", (Object)name);
        }
    }

    private void initThumbnailProvider(ServiceReference ref) {
        ThumbnailProvider tprovider = (ThumbnailProvider)this.osgiComponentContext.locateService(PRED_REF_NAME, ref);
        if (tprovider != null) {
            String name = (String)ref.getProperty(THUMBNAIL_PROVIDER_NAME);
            if (name == null) {
                this.log.error("initFilter: Missing name for thumbnail provider {}", (Object)ref);
                return;
            }
            this.log.info("registering thumbnail provider {}", (Object)name);
            this.thumbnailProviders.put(name, tprovider);
        }
    }
}

