/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.impl;

import com.day.cq.commons.Externalizer;
import com.day.cq.commons.JcrLabeledResource;
import com.day.cq.commons.LabeledResource;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service(value={AdapterFactory.class})
public class CommonAdapterFactory
implements AdapterFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Class<LabeledResource> LR_CLASS = LabeledResource.class;
    private static final Class<Externalizer> EXTERNALIZER_CLASS = Externalizer.class;
    @Reference
    private Externalizer externalizer;
    @Property(name="adapters")
    private static final String[] ADAPTER_CLASSES = new String[]{LR_CLASS.getName(), EXTERNALIZER_CLASS.getName()};
    @Property(name="adaptables")
    private static final String[] ADAPTABLE_CLASSES = new String[]{Resource.class.getName(), ResourceResolver.class.getName()};

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        if (adaptable instanceof ResourceResolver) {
            return this.getAdapter((ResourceResolver)adaptable, type);
        }
        this.log.warn("Unable to handle adaptable {}", (Object)adaptable.getClass().getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(Resource resource, Class<AdapterType> type) {
        Node node;
        if (type == LR_CLASS && (node = (Node)resource.adaptTo(Node.class)) != null) {
            try {
                return (AdapterType)new JcrLabeledResource(node);
            }
            catch (RepositoryException e) {
                this.log.error("Error while creating JcrLabeledResource.", (Throwable)e);
            }
        }
        this.log.debug("Unable to adapt resource of {} to type {}", (Object)resource.getResourceType(), (Object)type.getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(ResourceResolver resource, Class<AdapterType> type) {
        if (type == EXTERNALIZER_CLASS) {
            return (AdapterType)this.externalizer;
        }
        this.log.debug("Unable to adapt resource resolver to type {}", (Object)type.getName());
        return null;
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }
}

