/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.feed;

import com.day.cq.commons.SimpleXml;
import com.day.cq.commons.feed.AbstractFeed;
import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;

public class AtomFeed
extends AbstractFeed {
    public AtomFeed(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws RepositoryException {
        super(null, req, resp);
    }

    public AtomFeed(Resource res, SlingHttpServletRequest req, SlingHttpServletResponse resp) throws RepositoryException {
        super(res, req, resp);
    }

    public void printHeader() throws IOException {
        this.initXml();
        this.xml.openDocument();
        SimpleXml.Element feed = this.xml.open("feed");
        feed.attr("xmlns", "http://www.w3.org/2005/Atom");
        if (!"".equals(this.getLanguage())) {
            feed.attr("xml:lang", this.getLanguage());
        }
        this.xml.open("title", this.getTitle(), false).attr("type", "html").close();
        this.xml.open("author");
        this.xml.open("name", this.getAuthorName(), true).close();
        if (!"".equals(this.getAuthorEmail())) {
            this.xml.open("email", this.getAuthorEmail(), false).close();
        }
        this.xml.close();
        this.xml.open("id", this.getFeedLink(), false).close();
        this.xml.open("link").attr("rel", "alternate").attr("type", "text/html").attr("href", this.getHtmlLink()).close();
        this.xml.open("link").attr("rel", "self").attr("type", this.getContentType()).attr("href", this.getFeedLink()).close();
        this.xml.open("updated", this.getPublishedDate(), false).close();
        this.xml.open("generator").attr("uri", this.getGeneratorLink()).attr("version", this.getGeneratorVersion()).text(this.getGeneratorName()).close();
    }

    public void printEntry() throws IOException {
        this.initXml();
        this.xml.omitXmlDeclaration(true);
        this.xml.open("entry");
        this.xml.open("title", this.getTitle(), false).attr("type", "html").close();
        this.xml.open("summary", this.getSummary(), false).attr("type", "html").close();
        this.xml.open("author");
        this.xml.open("name", this.getAuthorName(), true).close();
        if (!"".equals(this.getAuthorName())) {
            this.xml.open("email", this.getAuthorEmail(), false).close();
        }
        this.xml.close();
        this.xml.open("id", this.getFeedLink(), false).close();
        this.xml.open("updated", this.getPublishedDate(), false).close();
        this.xml.open("published", this.getPublishedDate(), false).close();
        this.xml.open("category").attr("term", this.getTags()).close();
        if (this.isFile()) {
            this.xml.open("link").attr("rel", "alternate").attr("type", this.getMimeType()).attr("href", this.getFileLink()).close();
            this.xml.open("link").attr("rel", "enclosure").attr("type", this.getMimeType()).attr("length", this.getFileSize()).attr("href", this.getFileLink()).close();
        } else {
            this.xml.open("link").attr("rel", "alternate").attr("type", this.getMimeType()).attr("href", this.getHtmlLink()).close();
            this.xml.open("link").attr("rel", "replies").attr("type", this.getMimeType()).attr("href", this.getCommentsLink()).close();
            this.xml.open("content").attr("xml:base", this.getBaseUrl()).attr("type", "html").text(this.getDescription(), false).close();
        }
        this.xml.tidyUp();
    }

    public String getContentType() {
        return "application/atom+xml";
    }
}

